/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.laborsub.utils.TreeNodeBUtil;
import com.ejianc.business.laborsub.vo.ContractDetailVO;
import com.ejianc.business.laborsub.vo.ContractOtherCostVO;
import com.ejianc.business.laborsub.vo.ContractVO;
import com.ejianc.business.sub.bean.ContractClauseEntity;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.ContractOtherCostEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.DraftTypeEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.mapper.ContractMapper;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractOtherCostService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    @Autowired
    private IContractDetailService detailService;
    @Autowired
    private IContractOtherCostService otherCostService;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "LABORSUB_CONTRACT";
    @Autowired
    private IContractService service;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @Override
    public ContractVO insertOrUpdate(ContractVO saveorUpdateVO, String authority) {
        List<ContractDetailEntity> beforeDetails;
        OrgVO orgVO;
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractEntity.class));
        if (entity.getId() == null) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setSignatureStatus(String.valueOf(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode()));
                entity.setBillCode((String)billCode.getData());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
                entity.setMainContractCreateDate(new Date());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBaseMoney(entity.getContractAmt());
        entity.setBaseMoneyWithTax(entity.getContractAmtWithTax());
        entity.setBeforeChangeMny(entity.getContractAmt());
        entity.setBeforeChangeMnyWithTax(entity.getContractAmtWithTax());
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                ContractEntity contract = (ContractEntity)((Object)this.service.getById(entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    this.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else {
                this.delContractFile(entity.getContractFileId(), authority);
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        if (null != entity.getOrgId() && null != (orgVO = (OrgVO)this.iOrgApi.getOneById(entity.getOrgId()).getData()).getParentId()) {
            entity.setParentOrgId(orgVO.getParentId());
            entity.setParentOrgName(orgVO.getpFName());
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = entity.getDetailList())) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : beforeDetails) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ContractDetailEntity cdEntity : beforeDetails) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    private boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_money_with_tax) as baseTaxMoney, sum(contract_amt_with_tax) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        List otherCostEntityListDb;
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
        contractVO.setContractType(Integer.valueOf(1));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.detailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            for (ContractDetailEntity cdEntity : detailEntityListDb) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityListDb, ContractDetailVO.class);
            contractVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
        }
        if (CollectionUtils.isNotEmpty((Collection)(otherCostEntityListDb = this.otherCostService.queryList(queryParam, false)))) {
            List resultMapList = BeanMapper.mapList((Iterable)otherCostEntityListDb, ContractOtherCostVO.class);
            contractVO.setOtherCostList(resultMapList);
        }
        return contractVO;
    }

    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO recordVO = new ContractVO();
        BigDecimal contractAmtWithTax = contractEntity.getContractAmtWithTax() == null ? BigDecimal.ZERO : contractEntity.getContractAmtWithTax();
        recordVO.setId(id);
        recordVO.setContractAmtWithTax(contractAmtWithTax);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.orderByDesc(ContractEntity::getSignDate);
        List supplementEntities = super.list((Wrapper)lambda);
        recordVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, ContractVO.class));
        recordVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (ContractEntity c : supplementEntities) {
                if (c.getContractAmtWithTax() == null) continue;
                allSupplementAmt = c.getContractAmtWithTax().add(allSupplementAmt);
            }
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        recordVO.setSupplementAmtRate(BigDecimal.ZERO != allSupplementAmt && BigDecimal.ZERO != contractAmtWithTax ? allSupplementAmt.divide(contractAmtWithTax, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode() == contractEntity.getBillState() || BillStateEnum.COMMITED_STATE.getBillStateCode() == contractEntity.getBillState())) {
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO saveorUpdateVO) {
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractEntity.class));
        if ((saveorUpdateVO.getId() == null || saveorUpdateVO.getId() == 0L) && saveorUpdateVO.getMainContractId() != null) {
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(ContractEntity::getMainContractId, (Object)saveorUpdateVO.getMainContractId());
            lambdaQuery.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString())).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
            int num = this.service.count((Wrapper)lambdaQuery);
            if (num > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
            }
            List<ContractDetailEntity> detailList = entity.getDetailList();
            List<ContractOtherCostEntity> otherCostList = entity.getOtherCostList();
            List<ContractClauseEntity> clauseList = entity.getClauseList();
            QueryParam parm = new QueryParam();
            parm.getParams().put("main_contract_id", new Parameter("eq", (Object)entity.getMainContractId()));
            List supplementList = this.service.queryList(parm, false);
            String supplementNum = "";
            supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
            ContractEntity mainContract = (ContractEntity)((Object)this.service.selectById(saveorUpdateVO.getMainContractId()));
            if (mainContract != null) {
                entity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)mainContract), ContractEntity.class));
                entity.setId(null);
                entity.setCreateTime(new Date());
                entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                entity.setBillCode(entity.getBillCode() + "2" + supplementNum);
                entity.setContractName(saveorUpdateVO.getContractName());
                entity.setSignDate(saveorUpdateVO.getSignDate());
                entity.setOperatorId(saveorUpdateVO.getOperatorId());
                entity.setOperatorName(saveorUpdateVO.getOperatorName());
                entity.setPerformanceStatus(saveorUpdateVO.getPerformanceStatus());
                entity.setDraftType(saveorUpdateVO.getDraftType());
                entity.setContractFilePath(saveorUpdateVO.getContractFilePath());
                entity.setContractFileId(saveorUpdateVO.getContractFileId());
                entity.setContractTemplateId(saveorUpdateVO.getContractTemplateId());
                entity.setContractTemplateName(saveorUpdateVO.getContractTemplateName());
                entity.setContractFileVersionId(saveorUpdateVO.getContractFileVersionId());
                entity.setContractFileVersion(saveorUpdateVO.getContractFileVersion());
                entity.setSupplementDescribe(saveorUpdateVO.getSupplementDescribe());
                entity.setContractAmt(saveorUpdateVO.getContractAmt());
                entity.setContractAmtWithTax(saveorUpdateVO.getContractAmtWithTax() == null ? new BigDecimal("0") : saveorUpdateVO.getContractAmtWithTax());
                entity.setContractTaxAmt(saveorUpdateVO.getContractTaxAmt());
                entity.setSubContractAmt(saveorUpdateVO.getSubContractAmt());
                entity.setSubContractAmtWithTax(saveorUpdateVO.getSubContractAmtWithTax());
                entity.setSubContractTaxAmt(saveorUpdateVO.getSubContractTaxAmt());
                entity.setOtherAmt(saveorUpdateVO.getOtherAmt());
                entity.setOtherAmtWithTax(saveorUpdateVO.getOtherAmtWithTax());
                entity.setOtherTaxAmt(saveorUpdateVO.getOtherTaxAmt());
                entity.setDetailList(detailList);
                entity.setOtherCostList(otherCostList);
                entity.setClauseList(clauseList);
                entity.setBeforeChangeMnyWithTax(null);
                entity.setBeforeChangeMny(null);
                entity.setChangingMny(null);
                entity.setBeforeChangeMnyWithTax(null);
                entity.setChangeCode(null);
                entity.setChangeVersion(null);
                entity.setChangeId(null);
                entity.setChangeStatus(1);
                entity.setSupplementFlag(1);
                entity.setMainContractId(saveorUpdateVO.getMainContractId());
                entity.setMainContractCode(saveorUpdateVO.getMainContractCode());
                entity.setMainContractName(saveorUpdateVO.getMainContractName());
            } else {
                throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
            }
        }
        entity.setBaseMoney(entity.getContractAmt());
        entity.setBaseMoneyWithTax(entity.getContractAmtWithTax());
        entity.setBeforeChangeMny(entity.getContractAmt());
        entity.setBeforeChangeMnyWithTax(entity.getContractAmtWithTax());
        List<ContractDetailEntity> beforeDetails = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : beforeDetails) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ContractDetailEntity cdEntity : beforeDetails) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(Integer.valueOf(1));
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)1);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        if (supplementList.size() > 0) {
            return false;
        }
        return true;
    }
}

