/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.PerformanceStatusEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISignatureService;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="signatureService")
public class SignatureServiceImpl
implements ISignatureService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        this.logger.info("\u8fdb\u5165\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6d41\u7a0b------------->");
        if ("laborSubContract".equals(refCode)) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
            if (contractEntity == null) return CommonResponse.error((String)"\u627e\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u5408\u540c\u4e3b\u952e\uff01");
            if (signatureStatus == SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) {
                contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().toString());
                contractEntity.setEffectiveDate(new Date());
            } else {
                contractEntity.setSignatureStatus(String.valueOf(signatureStatus));
            }
            this.contractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            return CommonResponse.success();
        } else {
            if (!"laborSubChangeContract".equals(refCode)) return CommonResponse.error((String)"\u8bf7\u68c0\u67e5refCode\u503c\u662f\u5426\u6b63\u786e\uff01");
            ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(id));
            if (changeEntity == null) return CommonResponse.error((String)"\u627e\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u5408\u540c\u4e3b\u952e\uff01");
            Boolean changeContractFlag = false;
            if (signatureStatus == SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) {
                changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
                changeEntity.setEffectiveDate(new Date());
                changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().toString());
                changeContractFlag = true;
            } else {
                changeEntity.setSignatureStatus(String.valueOf(signatureStatus));
            }
            this.changeService.saveOrUpdate((Object)changeEntity);
            this.logger.info("\u53d8\u66f4\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            if (!changeContractFlag.booleanValue()) return CommonResponse.success();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
            updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
            this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
            this.logger.info("\u7b7e\u7ae0\u72b6\u6001\u4e3a\u5df2\u7b7e\u7ae0\uff0c\u56de\u5199\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001---------------->");
        }
        return CommonResponse.success();
    }
}

