package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.laborsub.vo.ContractVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.PerformanceStatusEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "LABORSUB_CONTRACT";//此处需要根据实际修改

    @Autowired
    private IContractService service;

    private final String ENTITY_REF_CODE = "laborSubContract";

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
    	ContractVO vo = service.insertOrUpdate(saveorUpdateVO, authority);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        CommonResponse<BillTypeVO> billTypeResp = billTypeApi.getByRefCode(ENTITY_REF_CODE);
        if(!billTypeResp.isSuccess()) {
            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", ENTITY_REF_CODE, billTypeResp.getMsg());
            return CommonResponse.error("查询元数据信息失败");
        }

        ContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", billTypeResp.getData().getBillCode());
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

//    /**
//     * @Description queryList 查询列表
//     * @param param
//     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
//     */
//    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {
//        /** 模糊搜索配置字段示例 */
//        List<String> fuzzyFields = param.getFuzzyFields();
//        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//
//        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//
//        IPage<ContractEntity> page = service.queryPage(param,false);
//        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));
//
//        return CommonResponse.success("查询列表数据成功！",pageData);
//    }




    /**
     * @Description 导出
     * 导出内容和列表查询内容一样
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        param.setPageSize(10000);
        CommonResponse<JSONObject> commonResponse = pageList(param);
        List<ContractVO> contractVOList = new ArrayList<>();
        if (null != commonResponse.getData()){
            contractVOList = (List<ContractVO>) commonResponse.getData().get("records");
            if (null != contractVOList && contractVOList.size() > 0){
                contractVOList.forEach(c -> {
                    //设置合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
                    if (null == c.getPerformanceStatus() || "1".equals(c.getPerformanceStatus())){
                        c.setPerformanceStatus("未签订");
                    }else if ("2".equals(c.getPerformanceStatus())){
                        c.setPerformanceStatus("履约中");
                    }else if ("3".equals(c.getPerformanceStatus())){
                        c.setPerformanceStatus("已封账");
                    }else if("4".equals(c.getPerformanceStatus())){
                        c.setPerformanceStatus("已解除");
                    }
                    //设置签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
                    if (null == c.getSignatureStatus() || "1".equals(c.getSignatureStatus())){
                        c.setSignatureStatus("未签章");
                    }else if ("2".equals(c.getSignatureStatus())){
                        c.setSignatureStatus("待乙方签章");
                    }else if ("3".equals(c.getSignatureStatus())){
                        c.setSignatureStatus("待甲方签章");
                    }else if ("4".equals(c.getSignatureStatus())){
                        c.setSignatureStatus("已签章");
                    }
                    //设置单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
                    if (null == c.getBillState() || 0 == c.getBillState()){
                        c.setBillStateName("自由态");
                    }else if (1 == c.getBillState()){
                        c.setBillStateName("已提交");
                    }else if (2 == c.getBillState()){
                        c.setBillStateName("审批中");
                    }else if (3 == c.getBillState()){
                        c.setBillStateName("审批通过");
                    }else if (4 == c.getBillState()){
                        c.setBillStateName("驳回");
                    }else if (5 == c.getBillState()){
                        c.setBillStateName("提交后有人审批中");
                    }
                });
            }
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("laborsubContract-export.xlsx", beans, response);
    }



    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
//        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        //根据用户orgid来进行本下查询
        Long orgId = InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList = iOrgApi.findChildrenByParentId(orgId).getData();
        List<Long> orgIdList = new ArrayList<>();
        for (OrgVO vo : orgVOList){
            orgIdList.add(vo.getId());
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData= service.queryPage(param,false);


        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询当前合同下补充协议列表
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description saveOrUpdateSupplement 新增或者修改补充协议
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO saveorUpdateVO) {
        ContractVO vo = service.saveOrUpdateSupplement(saveorUpdateVO);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }


    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag){
            return CommonResponse.success();
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }


    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/signatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        ContractEntity contractEntity = service.selectById(id);
        if (contractEntity != null){
            contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode().toString());
            contractEntity.setEffectiveDate(new Date());
            service.saveOrUpdate(contractEntity);
        }
        return CommonResponse.success();
    }

}
