package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.laborsub.vo.ContractVO;
import com.ejianc.business.sub.bean.*;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.DraftTypeEnum;
import com.ejianc.business.sub.enums.PerformanceStatusEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("change") 
public class ChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IChangeService changeService;

	@Autowired
	private IContractService contractService;

	@Autowired
	private IRecordService recordService;

	@Autowired
	private IContractDetailService contractDetailService;

	@Autowired
	private IContractClauseService contractClauseService;

	@Autowired
	private IContractOtherCostService contractOtherCostService;

	@Autowired
	private IChangeDetailService changeDetailService;

	@Autowired
	private IChangeOtherCostService changeOtherCostService;

    @Autowired
    private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IAttachmentApi attachmentApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/**更新变更的审批时间  begin */
		ChangeEntity changeEntity = changeService.selectById(billId);
		logger.info("进入变更终审！变更表数据------------->", changeEntity);
		//后期修改：确定单据生效时间位置，更新单据生效时间
//		LambdaUpdateWrapper<ChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
//		updateWrapper.set(ChangeEntity::getEffectiveDate, new Date());
//		updateWrapper.eq(ChangeEntity::getId, changeEntity.getId());
//		changeService.update(changeEntity, updateWrapper, false);

		/**复制合同表数据到记录表 begin */
		ContractVO contractVO = contractService.queryDetail(changeEntity.getContractId());
		Map<Long, Integer> contIdVersionMap =  new HashMap<>();
		RecordEntity recordEntity = BeanMapper.map(contractVO, RecordEntity.class);
		recordEntity.setContractId(recordEntity.getId());
		recordEntity.setChangeVersion(recordEntity.getVersion() - 1);
		recordEntity.setId(null);
		logger.info("变更前主合同数据", JSONObject.toJSONString(contractVO));
		logger.info("变更前主合同子表detail数据", JSONObject.toJSONString(contractVO.getDetailList()));
		logger.info("记录表从主合同表复制的数据", JSONObject.toJSONString(recordEntity));
		logger.info("记录表从主合同表复制的数据的子表detail数据", JSONObject.toJSONString(recordEntity.getDetailList()));

		if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
			recordEntity.getDetailList().forEach(vo -> {
				contIdVersionMap.put(vo.getId(), vo.getVersion());
				vo.setSrcTableId(vo.getId());
				vo.setId(null);
			});
		}
		if(CollectionUtils.isNotEmpty(recordEntity.getClauseList())){
			recordEntity.getClauseList().forEach(vo -> {
				vo.setId(null);
			});
		}
		if(CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())){
			recordEntity.getOtherCostList().forEach(vo -> {
				vo.setSrcTableId(vo.getId());
				vo.setId(null);
			});
		}

		logger.info("记录表从主合同表复制的子表detail数据，设置id后的值", JSONObject.toJSONString(recordEntity.getDetailList()));
		recordService.saveOrUpdate(recordEntity, false);
		/**复制合同表数据到记录表 end */

		/**更新变更表表头数据到合同 begin */
		logger.info("更新变更数据到主合同表,contractVO---------------->", contractVO);
		ContractEntity contractEntity = BeanMapper.map(contractVO, ContractEntity.class);
		//基本信息
		contractEntity.setContractName(changeEntity.getContractName());
		contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
		contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
		contractEntity.setSupplierId(changeEntity.getSupplierId());
		contractEntity.setSupplierName(changeEntity.getSupplierName());
		contractEntity.setSignDate(changeEntity.getSignDate());
		contractEntity.setSignPlace(changeEntity.getSignPlace());
		contractEntity.setPayScale(changeEntity.getPayScale());
		contractEntity.setDraftType(changeEntity.getDraftType());
		contractEntity.setContractFilePath(changeEntity.getContractFilePath());
		contractEntity.setContractFileId(changeEntity.getContractFileId());
		contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
		contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
		contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
		contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
		contractEntity.setProjectAddress(changeEntity.getProjectAddress());

		//劳务分包人资质
		contractEntity.setMaterialId(changeEntity.getMaterialId());
		contractEntity.setMaterialName(changeEntity.getMaterialName());
		contractEntity.setCertificateNo(changeEntity.getCertificateNo());
		contractEntity.setMaterialLicenceIssuingAuthority(changeEntity.getMaterialLicenceIssuingAuthority());
		contractEntity.setMaterialGrantDate(changeEntity.getMaterialGrantDate());
		contractEntity.setMaterialValidTillDate(changeEntity.getMaterialValidTillDate());
		contractEntity.setSafetyProductionLicenseNo(changeEntity.getSafetyProductionLicenseNo());
		contractEntity.setSafetyCertiGrantDate(changeEntity.getSafetyCertiGrantDate());
		contractEntity.setSafetyCertiValidTillDate(changeEntity.getSafetyCertiValidTillDate());
		//合同工期
		contractEntity.setProjectStartDate(changeEntity.getProjectStartDate());
		contractEntity.setPlannedFinishDate(changeEntity.getPlannedFinishDate());
		contractEntity.setContractDaysLimit(changeEntity.getContractDaysLimit());
		//项目经理代表人
		contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
		contractEntity.setFirstPartyProjectManagerLink(changeEntity.getFirstPartyProjectManagerLink());
		contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
		contractEntity.setFirstPartyProjectManagerPost(changeEntity.getFirstPartyProjectManagerPost());
		contractEntity.setSecondPartyProjectManagerId(changeEntity.getSecondPartyProjectManagerId());
		contractEntity.setSecondPartyProjectManagerIdCard(changeEntity.getSecondPartyProjectManagerIdCard());
		contractEntity.setSecondPartyProjectManagerLink(changeEntity.getSecondPartyProjectManagerLink());
		contractEntity.setSecondPartyProjectManagerName(changeEntity.getSecondPartyProjectManagerName());
		contractEntity.setSecondPartyProjectManagerPost(changeEntity.getSecondPartyProjectManagerPost());
		//分包款项
		contractEntity.setContractAmtWithTax(changeEntity.getContractAmtWithTax());
		contractEntity.setContractAmt(changeEntity.getContractAmt());
		contractEntity.setContractTaxAmt(changeEntity.getContractTaxAmt());
		contractEntity.setSubContractTaxAmt(changeEntity.getSubContractTaxAmt());
		contractEntity.setSubContractAmtWithTax(changeEntity.getSubContractAmtWithTax());
		contractEntity.setSubContractAmt(changeEntity.getSubContractAmt());
		contractEntity.setOtherAmt(changeEntity.getOtherAmt());
		contractEntity.setOtherAmtWithTax(changeEntity.getOtherAmtWithTax());
		contractEntity.setOtherTaxAmt(changeEntity.getOtherTaxAmt());

		/*
			起草方式为线下签订，则变更合同为已签章，直接生效。主合同状态改为已变更
			起草方式为线上起草、上传合同，则主合同状态改为变更单据已生效
		 */
		if (DraftTypeEnum.线下签订.getCode().toString().equals(changeEntity.getChangeDraftType())){
			contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());

            logger.info("1212-进入变更终审审核完回调------>合同提交，线下签订直接修改签章状态");
            //设置变更合同生效状态
            changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
            changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode().toString());
            //合同已生效，添加生效时间
            changeEntity.setEffectiveDate(new Date());

            //变更如果有附件需要合并附件
            //合并附件管理里的附件
            CommonResponse<List<AttachmentVO>> commonResponseFileList = attachmentApi.queryListBySourceId(billId, billTypeCode, "subChangeContractFile", "");
            if(!commonResponseFileList.isSuccess()) {
            	logger.error("根据BillId-{},billType-{},sourceType-{}查询附件列表失败，{}", billId, billTypeCode, "subChangeContractFile", commonResponseFileList.getMsg());
            	return CommonResponse.error("查询合同附件信息失败！");
			}
            if (null != commonResponseFileList.getData() && commonResponseFileList.getData().size() > 0){
                logger.info("进入合并附件----------->");
                CommonResponse c1 = attachmentApi.copyFilesFromSourceBillToTargetBill(billId.toString(), billTypeCode, "subChangeContractFile", contractEntity.getId().toString(), "BT211108000000002", "subContractBill");
                if (!c1.isSuccess()){
                    logger.info("合并附件管理中的附件失败--------------->失败信息------------>", c1.getMsg());
                    return CommonResponse.error("审批不成功，合并附件失败，错误信息：" + c1.getMsg());
                }
            }
            if (changeEntity.getContractFileId() != null && StringUtils.isNotEmpty(changeEntity.getContractFilePath())){
                //合并上传的协议附件
                CommonResponse c2 = attachmentApi.copyFilesFromSourceBillToTargetBill(billId.toString(), billTypeCode, "subContractFile", contractEntity.getId().toString(), "BT211108000000002", "subContractFile");
                if (!c2.isSuccess()){
                    logger.info("上传协议附件合并失败------------>失败信息---------->", c2.getMsg());
                    return CommonResponse.error("审批不成功，合并附件失败，错误信息：" + c2.getMsg());
                }
            }
		}else {
			contractEntity.setChangeStatus(ChangeStatusEnum.变更单据审批通过.getCode());
		}

        changeEntity.setCommitDate(new Date());
        changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
        changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
		changeService.saveOrUpdate(changeEntity);
		logger.info("更新变更表合同状态和数据,changeEntity---------->", changeEntity);

		contractService.updateById(contractEntity);
		logger.info("更新变更数据成功,contractEntity---------->", contractEntity);
		logger.info("1212-变更完成主合同修改状态----------->" + contractEntity.getChangeStatus());
		/**复制合同表数据到记录表 end */

		/**复制合同子表数据到记录表 begin */
		logger.info("1212-复制主合同表数据到记录表开始----------->" + contractEntity.getChangeStatus());
		ContractEntity contractChangeEntity = BeanMapper.map(changeEntity, ContractEntity.class);
		List<ChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
		Map<Long,Long> changDetailIdMap = new HashMap<>();
		/*
			变更详情表和合同详情表有一个字段不一样
			变更详情表里 来源子表主键 srcTblId
			合同详情表里 变更子表主键 changeBid
		 */
		if (CollectionUtils.isNotEmpty(changeDetailList)){
			changeDetailList.forEach(changeDetailEntity -> {
				//设置id和来源子表主键对应map
				changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId());
			});
		}

		List<ContractDetailEntity> contractDetailList = contractChangeEntity.getDetailList();
		if(CollectionUtils.isNotEmpty(contractDetailList)){
			contractDetailList.forEach(contractDetailEntity -> {
				//记录虚拟父子关系
				contractDetailEntity.setTid(contractDetailEntity.getId().toString());
				contractDetailEntity.setTpid(contractDetailEntity.getParentId()!= null&&contractDetailEntity.getParentId()>0?contractDetailEntity.getParentId().toString():"");
//				Long contractBid = contractDetailEntity.getSrcBid();
				Long contractBid = changDetailIdMap.get(contractDetailEntity.getId());

				contractDetailEntity.setContractId(changeEntity.getContractId());
//				contractDetailEntity.setSrcBid(contractDetailEntity.getId());
				//设置变更子表主键
				contractDetailEntity.setChangeBid(contractDetailEntity.getId());

				//合同子表对应变更子表主键
				contractDetailEntity.setId(contractBid);
				contractDetailEntity.setVersion(contIdVersionMap.get(contractBid));
			});
			contractDetailService.saveOrUpdateBatch(contractDetailList, contractDetailList.size(), false);

			//根据更新后数据维护树形关系
			Map<String,Long> idMap=new HashMap<>();
			contractDetailList.forEach(cdEntity ->{
				idMap.put(cdEntity.getTid(),cdEntity.getId());
			});

			contractDetailList.forEach(cdEntity ->{
				if(StringUtils.isNotEmpty(cdEntity.getTpid())){
					cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
				}
			});
			contractDetailService.saveOrUpdateBatch(contractDetailList, contractDetailList.size(), false);
		}


		//其他费用表
		List<ChangeOtherCostEntity> changeOtherCostList = changeEntity.getOtherCostList();
		Map<Long,Long> changOtherCostIdMap = new HashMap<>();
		if (CollectionUtils.isNotEmpty(changeOtherCostList)){
			changeOtherCostList.forEach(changeOtherCostEntity -> {
				//设置id和来源子表主键对应map
				changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId());
			});
		}
		List<ContractOtherCostEntity> contractOtherCostList = contractChangeEntity.getOtherCostList();
		if(CollectionUtils.isNotEmpty(contractOtherCostList)){
			contractOtherCostList.forEach(contractOtherCostEntity -> {
				//记录虚拟父子关系
				Long contractBid = changOtherCostIdMap.get(contractOtherCostEntity.getId());

				contractOtherCostEntity.setContractId(changeEntity.getContractId());
				//设置变更子表主键
				contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());

				//合同子表对应变更子表主键
				contractOtherCostEntity.setId(contractBid);
				contractOtherCostEntity.setVersion(contIdVersionMap.get(contractBid));
			});
			contractOtherCostService.saveOrUpdateBatch(contractOtherCostList, contractOtherCostList.size(), false);
		}



		//先删除合同条款表
		List<ContractClauseEntity> contractClauseList = contractEntity.getClauseList();
		if(CollectionUtils.isNotEmpty(contractClauseList)){
			contractClauseService.removeByIds(contractClauseList.stream().map(ContractClauseEntity::getId).collect(Collectors.toList()),false);
		}

		List<ContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
		if(CollectionUtils.isNotEmpty(contractChangeClauseList)){
			contractChangeClauseList.forEach(clauseEntity -> {
				clauseEntity.setId(null);
				clauseEntity.setContractId(changeEntity.getContractId());
			});
			contractClauseService.saveOrUpdateBatch(contractChangeClauseList, contractChangeClauseList.size(), false);
		}

		/**复制合同子表数据到记录表 end */
		return CommonResponse.success("审批回调合同成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//提交通过、且未签章则可弃审
		ChangeEntity changeEntity = changeService.selectById(billId);
		ContractVO contractVO = contractService.queryDetail(changeEntity.getContractId());
		//合同是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if (contractVO != null){
			if (!(BillStateEnum.PASSED_STATE.getBillStateCode() == contractVO.getBillState() || BillStateEnum.COMMITED_STATE.getBillStateCode() == contractVO.getBillState())){
				return CommonResponse.error("当前单据没有审批通过，不能弃审！");
			}else if (!(SignatureStatusEnum.未签章.getCode().toString().equals(contractVO.getSignatureStatus()))){
				return CommonResponse.error("当前单据已有签章流程，不能撤回！");
			}else if(!res.isSuccess()) {
				return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
			}
		}

		//查询变更表新添加的字段，从主表中删除
		QueryParam subQueryParam = new QueryParam();
		subQueryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractVO.getId()));
		subQueryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, changeEntity.getId()));
		subQueryParam.getParams().put("change_type", new Parameter(QueryParam.EQ, "新增项"));
		List<ChangeDetailEntity> changeDetailList = changeDetailService.queryList(subQueryParam);
		List<ChangeOtherCostEntity> changeOtherCostList = changeOtherCostService.queryList(subQueryParam);
		Map<Long, Long> detailDelIdMap = new HashMap<>();
		Map<Long, Long> otherCostDelIdMap = new HashMap<>();
		if (changeDetailList != null && changeDetailList.size() > 0){
			for (ChangeDetailEntity c : changeDetailList){
				detailDelIdMap.put(c.getSrcTblId(), c.getSrcTblId());
			}
		}
		if (changeOtherCostList != null && changeOtherCostList.size() > 0){
			for (ChangeOtherCostEntity c : changeOtherCostList){
				otherCostDelIdMap.put(c.getSrcTblId(), c.getSrcTblId());
			}
		}

		//复制记录表中数据到主合同表
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractVO.getId()));
		queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, contractVO.getChangeId()));
//		queryParam.getParams().put("change_version", new Parameter(QueryParam.EQ, contractVO.getChangeVersion() - 1));
		List<RecordEntity> recordList = recordService.queryList(queryParam);
		if (CollectionUtils.isNotEmpty(recordList) && recordList.get(0) != null){


			//删除子表因变更新增的数据
			List<ContractDetailEntity> contractDetailList = BeanMapper.mapList(contractVO.getDetailList(), ContractDetailEntity.class);
			for (ContractDetailEntity c : contractDetailList){
				if (detailDelIdMap.get(c.getId()) != null){
					c.setRowState("del");
				}
			}
			contractDetailService.saveOrUpdateBatch(contractDetailList);

			List<ContractOtherCostEntity> contractOtherCostList = BeanMapper.mapList(contractVO.getOtherCostList(), ContractOtherCostEntity.class);
			for (ContractOtherCostEntity c : contractOtherCostList){
				if (otherCostDelIdMap.get(c.getId()) != null){
					c.setRowState("del");
				}
			}
			contractOtherCostService.saveOrUpdateBatch(contractOtherCostList);



			ContractEntity contractEntity = BeanMapper.map(recordList.get(0), ContractEntity.class);
			contractEntity.setId(contractVO.getId());
			Map<Long, Long> otherCostIdMap = new HashMap<>();
			Map<Long, Long> detailIdMap = new HashMap<>();
			//从记录其他花费子表拿到来源子表id值
			recordList.get(0).getOtherCostList().forEach(vo ->{
				otherCostIdMap.put(vo.getId(), vo.getSrcTableId());
			});
			//从记录详情子表拿到来源子表id值
			recordList.get(0).getDetailList().forEach(vo ->{
				detailIdMap.put(vo.getId(), vo.getSourceId());
			});
			//设置子表id值
			if(CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
				contractEntity.getDetailList().forEach(vo -> {
					vo.setId(detailIdMap.get(vo.getId()));
				});
			}

			if(CollectionUtils.isNotEmpty(contractEntity.getOtherCostList())){
				contractEntity.getOtherCostList().forEach(vo -> {
					vo.setId(detailIdMap.get(vo.getId()));
				});
			}

			if(CollectionUtils.isNotEmpty(contractEntity.getClauseList())){
				contractEntity.getClauseList().forEach(vo -> {
					vo.setId(null);
				});
			}
			contractService.saveOrUpdate(contractEntity, false);
			//删除记录表
			recordService.removeById(recordList.get(0).getId());



			return CommonResponse.success();
		}
		return CommonResponse.error("查询不到变更记录，请联系系统管理员。");
	}

}
