package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.PerformanceStatusEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISignatureService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("signatureService")
public class SignatureServiceImpl implements ISignatureService {
    @Autowired
    private IContractService contractService;

    @Autowired
    private IChangeService changeService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SessionManager sessionManager;


    private IAttachmentApi attachmentApi;


    /**
     * 签章流程
     * 判断合同类型做不同操作
     * @param id
     * @param signatureStatus
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        /*
            主合同，已签章：
            改变签章状态，改变合同状态
            变更合同，已签章：
            改变签章状态，改变合同状态，回写主合同信息
         */
        logger.info("进入签章状态修改流程------------->");
        if ("laborSubContract".equals(refCode)){//主合同
            ContractEntity contractEntity = contractService.selectById(id);
            if (contractEntity != null){
                if (signatureStatus == SignatureStatusEnum.已签章.getCode()){
                    contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
                    contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode().toString());
                    contractEntity.setEffectiveDate(new Date());
                }else {
                    contractEntity.setSignatureStatus(String.valueOf(signatureStatus));
                }
                contractService.saveOrUpdate(contractEntity);
                logger.info("主合同签章状态已修改---------------->");
            }else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }else if ("laborSubChangeContract".equals(refCode)){//变更合同
            ChangeEntity changeEntity = changeService.selectById(id);
            if (changeEntity != null){
                Boolean changeContractFlag = false;
                if (signatureStatus == SignatureStatusEnum.已签章.getCode()){
                    changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
                    changeEntity.setEffectiveDate(new Date());
                    changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode().toString());

                    //变更如果有附件需要合并附件
                    //合并附件管理里的附件
                    CommonResponse<List<AttachmentVO>> commonResponseFileList = attachmentApi.queryListBySourceId(id, "BT211108000000003", "subChangeContractFile", "");
                    if (commonResponseFileList.getData().size() > 0){
                        logger.info("进入合并附件----------->");
                        CommonResponse c1 = attachmentApi.copyFilesFromSourceBillToTargetBill(id.toString(), "BT211108000000003", "subChangeContractFile", changeEntity.getContractId().toString(), "BT211108000000002", "subContractBill");
                        if (c1.getCode() != 0){
                            logger.info("合并附件管理中的附件失败--------------->失败信息------------>", c1.getMsg());
                            return c1.error("审批不成功，合并附件失败，错误信息：" + c1.getMsg());
                        }
                    }
                    if (changeEntity.getContractFileId() != null && StringUtils.isNotEmpty(changeEntity.getContractFilePath())){
                        //合并上传的协议附件
                        CommonResponse c2 = attachmentApi.copyFilesFromSourceBillToTargetBill(id.toString(), "BT211108000000003", "subContractFile", changeEntity.getContractId().toString(), "BT211108000000002", "subContractFile");
                        if (c2.getCode() != 0){
                            logger.info("上传协议附件合并失败------------>失败信息---------->", c2.getMsg());
                            return c2.error("审批不成功，合并附件失败，错误信息：" + c2.getMsg());
                        }
                    }

                    changeContractFlag = true;
                }else {
                    changeEntity.setSignatureStatus(String.valueOf(signatureStatus));
                }
                changeService.saveOrUpdate(changeEntity);
                logger.info("变更合同签章状态已修改---------------->");
                if (changeContractFlag){
                    //回写主合同（变更合同签章状态，主合同变更状态）
                    LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
                    updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.已变更.getCode());
                    contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
                    logger.info("签章状态为已签章，回写主合同签章状态---------------->");
                }
            }else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }else {
            return CommonResponse.error("请检查refCode值是否正确！");
        }
        return CommonResponse.success("签章状态修改成功！");
    }
}
