package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.law.vo.ThawFundZiVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 资金解冻表子表
 *
 * @author generator
 */
public class ThawFundZiVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long frozenId; // 冻结id
    private Long zhuId;//主表id
    private String frozenCode; // 冻结编码
    private Long thawCode; // 解冻编号
    private String thawCodeName; // 解冻编号名称
    private Long thawState; // 解冻状态
    private String thawStateName; // 解冻状态名称
    private Long thawType; // 解冻类型
    private String thawTypeName; // 解冻类型名称
    private BigDecimal totalThawAmount; // 解冻金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date thawDate; // 解冻日期
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private Long lawsuitCode; // 诉讼案号
    private String lawsuitCodeName; // 诉讼案号名称
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String thawReason; // 解冻事由

    private List<ThawFundZiVO> thawFundZiList = new ArrayList<>(); // 资金解冻表子表


    private Long departmentId; // 项目部
    private String departmentName; // 项目部名称
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private Long departmentCode; //项目部编码
    private String departmentCodeName;// 项目部编码名称

    public Long getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(Long departmentCode) {
        this.departmentCode = departmentCode;
    }

    public String getDepartmentCodeName() {
        return departmentCodeName;
    }

    public void setDepartmentCodeName(String departmentCodeName) {
        this.departmentCodeName = departmentCodeName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getZhuId() {
        return zhuId;
    }

    public void setZhuId(Long zhuId) {
        this.zhuId = zhuId;
    }

    @ReferSerialTransfer(referCode = "law-frozen-fund-zi")
    public Long getFrozenId() {
        return frozenId;
    }

    @ReferDeserialTransfer
    public void setFrozenId(Long frozenId) {
        this.frozenId = frozenId;
    }

    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }

    public Long getThawCode() {
        return thawCode;
    }

    public void setThawCode(Long thawCode) {
        this.thawCode = thawCode;
    }

    public String getThawCodeName() {
        return thawCodeName;
    }

    public void setThawCodeName(String thawCodeName) {
        this.thawCodeName = thawCodeName;
    }

    public Long getThawState() {
        return thawState;
    }

    public void setThawState(Long thawState) {
        this.thawState = thawState;
    }

    public String getThawStateName() {
        return thawStateName;
    }

    public void setThawStateName(String thawStateName) {
        this.thawStateName = thawStateName;
    }

    public Long getThawType() {
        return thawType;
    }

    public void setThawType(Long thawType) {
        this.thawType = thawType;
    }

    public String getThawTypeName() {
        return thawTypeName;
    }

    public void setThawTypeName(String thawTypeName) {
        this.thawTypeName = thawTypeName;
    }

    public BigDecimal getTotalThawAmount() {
        return totalThawAmount;
    }

    public void setTotalThawAmount(BigDecimal totalThawAmount) {
        this.totalThawAmount = totalThawAmount;
    }

    public Date getThawDate() {
        return thawDate;
    }

    public void setThawDate(Date thawDate) {
        this.thawDate = thawDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "law-case-info")
    public Long getLawsuitCode() {
        return lawsuitCode;
    }

    @ReferDeserialTransfer
    public void setLawsuitCode(Long lawsuitCode) {
        this.lawsuitCode = lawsuitCode;
    }

    public String getLawsuitCodeName() {
        return lawsuitCodeName;
    }

    public void setLawsuitCodeName(String lawsuitCodeName) {
        this.lawsuitCodeName = lawsuitCodeName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getThawReason() {
        return thawReason;
    }

    public void setThawReason(String thawReason) {
        this.thawReason = thawReason;
    }

    public List<ThawFundZiVO> getThawFundZiList() {
        return thawFundZiList;
    }

    public void setThawFundZiList(List<ThawFundZiVO> thawFundZiList) {
        this.thawFundZiList = thawFundZiList;
    }
}
