package com.ejianc.business.law.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 资金解冻表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_law_case_thaw_fund")
public class ThawFundEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="case_id")
    private Long caseId; // 案件id
    @TableField(value="case_code")
    private String caseCode; // 案件编号
    @TableField(value="frozen_id")
    private Long frozenId; // 冻结id
    @TableField(value="frozen_code")
    private String frozenCode; // 冻结编码
    @TableField(value="thaw_state")
    private Long thawState; // 解冻状态
    @TableField(value="thaw_state_name")
    private String thawStateName; // 解冻状态名称
    @TableField(value="thaw_type")
    private Long thawType; // 解冻类型
    @TableField(value="thaw_type_name")
    private String thawTypeName; // 解冻类型名称
    @TableField(value="department_id")
    private Long departmentId; // 项目部
    @TableField(value="department_name")
    private String departmentName; // 项目部名称
    @TableField(value="project_id")
    private Long projectId; // 工程
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="thaw_amount")
    private BigDecimal thawAmount; // 解冻金额
    @TableField(value="thaw_date")
    private Date thawDate; // 完全解冻日期
    @TableField(value="lawsuit_code")
    private Long lawsuitCode; // 诉讼案号
    @TableField(value="lawsuit_code_name")
    private String lawsuitCodeName; // 诉讼案号名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value = "unfreezable_amount")
    private BigDecimal unfreezableAmount; //可解冻金额
    @TableField(value = "frozen_type")
    private Long frozenType;//冻结类型
    @TableField(value = "frozen_type_name")
    private String frozenTypeName; //冻结类型名称
    @TableField(value = "total_frozen_price")
    private BigDecimal totalFrozenPrice;//冻结总金额

    public BigDecimal getTotalFrozenPrice() {
        return totalFrozenPrice;
    }

    public void setTotalFrozenPrice(BigDecimal totalFrozenPrice) {
        this.totalFrozenPrice = totalFrozenPrice;
    }

    public Long getFrozenType() {
        return frozenType;
    }

    public void setFrozenType(Long frozenType) {
        this.frozenType = frozenType;
    }

    public String getFrozenTypeName() {
        return frozenTypeName;
    }

    public void setFrozenTypeName(String frozenTypeName) {
        this.frozenTypeName = frozenTypeName;
    }

    public BigDecimal getUnfreezableAmount() {
        return unfreezableAmount;
    }

    public void setUnfreezableAmount(BigDecimal unfreezableAmount) {
        this.unfreezableAmount = unfreezableAmount;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="thawFundZiService", pidName = "zhuId")
    private List<ThawFundZiEntity> thawFundZiList = new ArrayList<>(); // 资金解冻表子表
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getCaseId() {
        return caseId;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public Long getFrozenId() {
        return frozenId;
    }

    public void setFrozenId(Long frozenId) {
        this.frozenId = frozenId;
    }
    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }
    public Long getThawState() {
        return thawState;
    }

    public void setThawState(Long thawState) {
        this.thawState = thawState;
    }
    public String getThawStateName() {
        return thawStateName;
    }

    public void setThawStateName(String thawStateName) {
        this.thawStateName = thawStateName;
    }
    public Long getThawType() {
        return thawType;
    }

    public void setThawType(Long thawType) {
        this.thawType = thawType;
    }
    public String getThawTypeName() {
        return thawTypeName;
    }

    public void setThawTypeName(String thawTypeName) {
        this.thawTypeName = thawTypeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getThawAmount() {
        return thawAmount;
    }

    public void setThawAmount(BigDecimal thawAmount) {
        this.thawAmount = thawAmount;
    }
    public Date getThawDate() {
        return thawDate;
    }

    public void setThawDate(Date thawDate) {
        this.thawDate = thawDate;
    }
    public Long getLawsuitCode() {
        return lawsuitCode;
    }

    public void setLawsuitCode(Long lawsuitCode) {
        this.lawsuitCode = lawsuitCode;
    }
    public String getLawsuitCodeName() {
        return lawsuitCodeName;
    }

    public void setLawsuitCodeName(String lawsuitCodeName) {
        this.lawsuitCodeName = lawsuitCodeName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<ThawFundZiEntity> getThawFundZiList() {
        return thawFundZiList;
    }

    public void setThawFundZiList(List<ThawFundZiEntity> thawFundZiList) {
        this.thawFundZiList = thawFundZiList;
    }
    
}
