package com.ejianc.business.law.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.law.bean.FrozenFundZiEntity;

/**
 * 资金冻结单
 *
 * @author generator
 */
@TableName("ejc_law_frozen_fund")
public class FrozenFundEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "org_id")
    private Long orgId; // 组织id
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value = "create_user_name")
    private String createUserName; // 编制人
    @TableField(value = "operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value = "operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value = "operator_code")
    private String operatorCode; // 经办人联系方式
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者
    @TableField(value = "remark")
    private String remark; // 异常解冻备注
    @TableField(value = "frozen_price")
    private BigDecimal frozenPrice; // 冻结总金额
    @TableField(value = "frozen_date")
    private Date frozenDate; // 冻结日期
    @TableField(value = "frozen_code")
    private String frozenCode; // 冻结编号
    @TableField(value = "case_id")
    private Long caseId; // 案件编号
    @TableField(value = "case_name")
    private String caseName; // 案件编号名称
    @TableField(value = "frozen_type")
    private Long frozenType; // 冻结类型
    @TableField(value = "frozen_type_name")
    private String frozenTypeName; // 冻结类型名称
    @TableField(value = "project_id")
    private Long projectId; // 工程
    @TableField(value = "project_name")
    private String projectName; // 工程名称
    @TableField(value = "department_id")
    private Long departmentId; // 项目部
    @TableField(value = "department_name")
    private String departmentName; // 项目部名称
    @TableField(value = "unfreezable_amount")
    private BigDecimal unfreezableAmount; //可解冻金额

    public BigDecimal getUnfreezableAmount() {
        return unfreezableAmount;
    }

    public void setUnfreezableAmount(BigDecimal unfreezableAmount) {
        this.unfreezableAmount = unfreezableAmount;
    }

    @TableField(exist = false)
    @SubEntity(serviceName = "frozenFundZiService" , pidName = "zhuId")
    private List<FrozenFundZiEntity> frozenFundZiList = new ArrayList<>(); // 资金冻结单子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getFrozenPrice() {
        return frozenPrice;
    }

    public void setFrozenPrice(BigDecimal frozenPrice) {
        this.frozenPrice = frozenPrice;
    }

    public Date getFrozenDate() {
        return frozenDate;
    }

    public void setFrozenDate(Date frozenDate) {
        this.frozenDate = frozenDate;
    }

    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }


    public Long getCaseId() {
        return caseId;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }

    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public Long getFrozenType() {
        return frozenType;
    }

    public void setFrozenType(Long frozenType) {
        this.frozenType = frozenType;
    }

    public String getFrozenTypeName() {
        return frozenTypeName;
    }

    public void setFrozenTypeName(String frozenTypeName) {
        this.frozenTypeName = frozenTypeName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }


    public List<FrozenFundZiEntity> getFrozenFundZiList() {
        return frozenFundZiList;
    }

    public void setFrozenFundZiList(List<FrozenFundZiEntity> frozenFundZiList) {
        this.frozenFundZiList = frozenFundZiList;
    }
}
