package com.ejianc.business.law.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.law.bean.CaseRegisteEntity;
import com.ejianc.business.law.bean.LedgerEntity;
import com.ejianc.business.law.service.ICaseRegisteService;
import com.ejianc.business.law.service.ILedgerService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.law.bean.InfoRegisterEntity;
import com.ejianc.business.law.service.IInfoRegisterService;
import com.ejianc.business.law.vo.InfoRegisterVO;

/**
 * 案件审理信息登记表
 *
 * @author generator
 */
@Controller
@RequestMapping("infoRegister")
public class InfoRegisterController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi iUserApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IInfoRegisterService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InfoRegisterVO> saveOrUpdate(@RequestBody InfoRegisterVO saveOrUpdateVO) {
        InfoRegisterEntity entity = BeanMapper.map(saveOrUpdateVO, InfoRegisterEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0) {
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }

        service.saveOrUpdate(entity, false);


        //案件台账关联更新
//        ledgerSaveOrUpdate(entity);
        //案件基本信息关联更新
        updateCaseRegister(entity);

        send(entity);

        InfoRegisterVO vo = BeanMapper.map(entity, InfoRegisterVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InfoRegisterVO> queryDetail(Long id) {
        InfoRegisterEntity entity = service.selectById(id);
        InfoRegisterVO vo = BeanMapper.map(entity, InfoRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InfoRegisterVO> vos) {
//        if(ListUtil.isNotEmpty(vos)){
//            for (InfoRegisterVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
//        }
//        service.removeByIds(vos.stream().map(InfoRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.error("表单数据已更新到台账中，无法删除！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InfoRegisterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());

        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<InfoRegisterEntity> page = service.queryPage(param, false);
        IPage<InfoRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InfoRegisterVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InfoRegisterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InfoRegister-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refInfoRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InfoRegisterVO>> refInfoRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InfoRegisterEntity> page = service.queryPage(param, false);
        IPage<InfoRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InfoRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param
     * @Description queryNum 查询
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Long> queryNum(Long caseId, Integer hearCount) {

        QueryParam param = new QueryParam();

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 案件编号 */
        param.getParams().put("caseId", new Parameter(QueryParam.EQ, caseId));
        /** 审理阶段 */
        param.getParams().put("hearCount", new Parameter(QueryParam.EQ, hearCount));

        IPage<InfoRegisterEntity> page = service.queryPage(param, false);

        return CommonResponse.success(page.getTotal());
    }


    @Autowired
    private IPushMessageApi pushMessageApi;

    public void send(InfoRegisterEntity entity) {

        ArrayList<String> strings1 = new ArrayList<>();
        ArrayList<String> strings = new ArrayList<>();
        strings.add("孙晓一测试");
        CommonResponse<List<UserVO>> allUserByRoleNameList = iUserApi.findAllUserByRoleNameList(strings);
        if (allUserByRoleNameList.getCode() == 0) {

            List<UserVO> data = allUserByRoleNameList.getData();
            for (UserVO userVO : data) {
                //if (userVO.getOrgId().equals(entity.getOrgId())){
                strings1.add(userVO.getId() + "");
                // }
            }
        }
        String[] strings2 = strings1.toArray(new String[strings1.size()]);
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);//发送企业微信标志
        //String[] receivers = new String[1];
        //receivers[0] = "553224391165485096";
        parameter.setReceivers(strings2);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("notice");//预警消息
        parameter.setSubject("案件编号：" + entity.getCaseName() + "，有了新的进展，请注意查看！");// 标题
        parameter.setContent("案件编号：000000000，提交了新的内容！");// 内容
        parameter.setPcUrl("/ejc-law-frontend/#/infoRegister/card?id=" + entity.getId());// pc端url
        //parameter.setMobileUrl("ydurl");// 移动端url
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", 1000038);//企业微信应用id
        weixineeParams.put("secret", "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE");//企业微信secret
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "案件消息通知");
        weixineeParams.put("description", "description");
        //weixineeParams.put("url", ("" + "&userid={userid}"));//移动端点击的url
        weixineeParams.put("btntxt", "点击查看");
        parameter.setWeixineeParams(weixineeParams);

        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            logger.error("消息发送成功---------------->" + result.getMsg());
        } else {
            logger.error("消息发送失败---------------->" + result.getMsg());
        }
    }

    /**
     * 案件信息登记表关联更新
     */
    @Autowired
    private ICaseRegisteService caseRegisterService;

    public void updateCaseRegister(InfoRegisterEntity entity) {
        CaseRegisteEntity caseRegisteEntity = caseRegisterService.getById(entity.getCaseId());
        caseRegisteEntity.setHearCount(entity.getHearCount());//案件审理阶段
        caseRegisteEntity.setFirstResultId(entity.getFirstResultId());
        caseRegisteEntity.setFirstResultName(entity.getFirstResultName());
        caseRegisteEntity.setFirstEndDate(entity.getFirstEndDate());//结案日期
        caseRegisteEntity.setFirstEndAmount(entity.getFirstEndAmount());//结案金额

        caseRegisterService.saveOrUpdate(caseRegisteEntity);
    }



    /**
     * 案件台账关联更新
     */
    @Autowired
    private ILedgerService ledgerService;

    private void ledgerSaveOrUpdate(InfoRegisterEntity entity) {
        LedgerEntity ledgerEntity = ledgerService.getOne(Wrappers.<LedgerEntity>lambdaQuery().eq(LedgerEntity::getCaseId, entity.getCaseId()));
        if (ledgerEntity != null) {
            ledgerEntity.setId(ledgerEntity.getId());
            ledgerEntity.setCaseResultId(entity.getFirstResultId());//案件结果
            ledgerEntity.setCaseResultName(entity.getFirstResultName());
            ledgerEntity.setEndAmount(entity.getFirstEndAmount());//结案金额
            ledgerEntity.setEndDate(entity.getFirstEndDate());//结案日期
            ledgerEntity.setInfoId(entity.getId());//案件审理信息id
        }
        ledgerService.saveOrUpdate(ledgerEntity);
    }

}
