package com.ejianc.business.law.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.law.bean.ExecutivePartyZiEntity;
/**
 * 起诉案件执行信息登记表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_law_prosecution_executive_register")
public class ProsecutionExecutiveRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="operator_code")
    private String operatorCode; // 经办人联系方式
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="executive_state_id")
    private Long executiveStateId; // 执行案状态
    @TableField(value="executive_state_name")
    private String executiveStateName; // 执行案状态名称
    @TableField(value="executive_start_date")
    private Date executiveStartDate; // 执行立案日期
    @TableField(value="executive_code")
    private String executiveCode; // 执行案号
    @TableField(value="pay_object_id")
    private Long payObjectId; // 支付对象
    @TableField(value="pay_object_name")
    private String payObjectName; // 支付对象名称
    @TableField(value="executive_amount")
    private BigDecimal executiveAmount; // 执行金额
    @TableField(value="pay_type_id")
    private Long payTypeId; // 支付方式
    @TableField(value="pay_type_name")
    private String payTypeName; // 支付方式名称
    @TableField(value="executive_count_id")
    private Long executiveCountId; // 执行法院
    @TableField(value="executive_count_name")
    private String executiveCountName; // 执行法院名称
    @TableField(value="executive_judge_name")
    private String executiveJudgeName; // 执行法官名称
    @TableField(value="executive_judge_code")
    private String executiveJudgeCode; // 执行法官联系方式
    @TableField(value="executive_type_id")
    private Long executiveTypeId; // 执行措施
    @TableField(value="executive_type_name")
    private String executiveTypeName; // 执行措施名称
    @TableField(value="executive_end_date")
    private Date executiveEndDate; // 执行结案日期
    @TableField(value="case_id")
    private Long caseId; // 案件编号
    @TableField(value="case_name")
    private String caseName; // 案件编号名称
    @TableField(value="closure_notice")
    private String closureNotice; // 结案通知书
    @TableField(value="execution_amount")
    private BigDecimal executionAmount; // 执行费
    @TableField(value="department_id")
    private Long departmentId; // 项目部
    @TableField(value="department_name")
    private String departmentName; // 项目部名称
    @TableField(value="executed_company_id")
    private Long executedCompanyId; // 被执行单位id
    @TableField(value="executed_company_name")
    private String executedCompanyName; // 被执行单位名称
    @TableField(value="executed_amount")
    private BigDecimal executedAmount; // 已执行金额
    @TableField(value = "actual_payment_price")
    private BigDecimal actualPaymentPrice;//实际支付金额
    @TableField(value = "actual_return_price")
    private BigDecimal actualReturnPrice;//实际支付金额
    
    @TableField(exist=false)
    @SubEntity(serviceName="executivePartyZiService",pidName = "zhuId")
    private List<ExecutivePartyZiEntity> executivePartyZiList = new ArrayList<>(); // 起诉案件执行情况登记代理人子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getExecutiveStateId() {
        return executiveStateId;
    }

    public void setExecutiveStateId(Long executiveStateId) {
        this.executiveStateId = executiveStateId;
    }
    public String getExecutiveStateName() {
        return executiveStateName;
    }

    public void setExecutiveStateName(String executiveStateName) {
        this.executiveStateName = executiveStateName;
    }
    public Date getExecutiveStartDate() {
        return executiveStartDate;
    }

    public void setExecutiveStartDate(Date executiveStartDate) {
        this.executiveStartDate = executiveStartDate;
    }
    public String getExecutiveCode() {
        return executiveCode;
    }

    public void setExecutiveCode(String executiveCode) {
        this.executiveCode = executiveCode;
    }
    public Long getPayObjectId() {
        return payObjectId;
    }

    public void setPayObjectId(Long payObjectId) {
        this.payObjectId = payObjectId;
    }
    public String getPayObjectName() {
        return payObjectName;
    }

    public void setPayObjectName(String payObjectName) {
        this.payObjectName = payObjectName;
    }
    public BigDecimal getExecutiveAmount() {
        return executiveAmount;
    }

    public void setExecutiveAmount(BigDecimal executiveAmount) {
        this.executiveAmount = executiveAmount;
    }
    public Long getPayTypeId() {
        return payTypeId;
    }

    public void setPayTypeId(Long payTypeId) {
        this.payTypeId = payTypeId;
    }
    public String getPayTypeName() {
        return payTypeName;
    }

    public void setPayTypeName(String payTypeName) {
        this.payTypeName = payTypeName;
    }
    public Long getExecutiveCountId() {
        return executiveCountId;
    }

    public void setExecutiveCountId(Long executiveCountId) {
        this.executiveCountId = executiveCountId;
    }
    public String getExecutiveCountName() {
        return executiveCountName;
    }

    public void setExecutiveCountName(String executiveCountName) {
        this.executiveCountName = executiveCountName;
    }
    public String getExecutiveJudgeName() {
        return executiveJudgeName;
    }

    public void setExecutiveJudgeName(String executiveJudgeName) {
        this.executiveJudgeName = executiveJudgeName;
    }
    public String getExecutiveJudgeCode() {
        return executiveJudgeCode;
    }

    public void setExecutiveJudgeCode(String executiveJudgeCode) {
        this.executiveJudgeCode = executiveJudgeCode;
    }
    public Long getExecutiveTypeId() {
        return executiveTypeId;
    }

    public void setExecutiveTypeId(Long executiveTypeId) {
        this.executiveTypeId = executiveTypeId;
    }
    public String getExecutiveTypeName() {
        return executiveTypeName;
    }

    public void setExecutiveTypeName(String executiveTypeName) {
        this.executiveTypeName = executiveTypeName;
    }
    public Date getExecutiveEndDate() {
        return executiveEndDate;
    }

    public void setExecutiveEndDate(Date executiveEndDate) {
        this.executiveEndDate = executiveEndDate;
    }
    public Long getCaseId() {
        return caseId;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }
    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }
    public String getClosureNotice() {
        return closureNotice;
    }

    public void setClosureNotice(String closureNotice) {
        this.closureNotice = closureNotice;
    }
    public BigDecimal getExecutionAmount() {
        return executionAmount;
    }

    public void setExecutionAmount(BigDecimal executionAmount) {
        this.executionAmount = executionAmount;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getExecutedCompanyId() {
        return executedCompanyId;
    }

    public void setExecutedCompanyId(Long executedCompanyId) {
        this.executedCompanyId = executedCompanyId;
    }
    public String getExecutedCompanyName() {
        return executedCompanyName;
    }

    public void setExecutedCompanyName(String executedCompanyName) {
        this.executedCompanyName = executedCompanyName;
    }
    public BigDecimal getExecutedAmount() {
        return executedAmount;
    }

    public void setExecutedAmount(BigDecimal executedAmount) {
        this.executedAmount = executedAmount;
    }
    

    public List<ExecutivePartyZiEntity> getExecutivePartyZiList() {
        return executivePartyZiList;
    }

    public void setExecutivePartyZiList(List<ExecutivePartyZiEntity> executivePartyZiList) {
        this.executivePartyZiList = executivePartyZiList;
    }

    public BigDecimal getActualPaymentPrice() {
        return actualPaymentPrice;
    }

    public void setActualPaymentPrice(BigDecimal actualPaymentPrice) {
        this.actualPaymentPrice = actualPaymentPrice;
    }

    public BigDecimal getActualReturnPrice() {
        return actualReturnPrice;
    }

    public void setActualReturnPrice(BigDecimal actualReturnPrice) {
        this.actualReturnPrice = actualReturnPrice;
    }
}
