/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.law.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.law.bean.CaseRegisteEntity;
import com.ejianc.business.law.bean.InfoRegisterEntity;
import com.ejianc.business.law.bean.LedgerEntity;
import com.ejianc.business.law.service.ICaseRegisteService;
import com.ejianc.business.law.service.IInfoRegisterService;
import com.ejianc.business.law.service.ILedgerService;
import com.ejianc.business.law.vo.InfoRegisterVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"infoRegister"})
public class InfoRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi iUserApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IInfoRegisterService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICaseRegisteService caseRegisterService;
    @Autowired
    private ILedgerService ledgerService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InfoRegisterVO> saveOrUpdate(@RequestBody InfoRegisterVO saveOrUpdateVO) {
        InfoRegisterEntity entity = (InfoRegisterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InfoRegisterEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.updateCaseRegister(entity);
        this.send(entity);
        InfoRegisterVO vo = (InfoRegisterVO)BeanMapper.map((Object)((Object)entity), InfoRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InfoRegisterVO> queryDetail(Long id) {
        InfoRegisterEntity entity = (InfoRegisterEntity)((Object)this.service.selectById(id));
        InfoRegisterVO vo = (InfoRegisterVO)BeanMapper.map((Object)((Object)entity), InfoRegisterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InfoRegisterVO> vos) {
        return CommonResponse.error((String)"\u8868\u5355\u6570\u636e\u5df2\u66f4\u65b0\u5230\u53f0\u8d26\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InfoRegisterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("caseCode");
        fuzzyFields.add("departmentName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("disputeTypeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InfoRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InfoRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInfoRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InfoRegisterVO>> refInfoRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InfoRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Long> queryNum(Long caseId, Integer hearCount) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("caseId", new Parameter("eq", (Object)caseId));
        param.getParams().put("hearCount", new Parameter("eq", (Object)hearCount));
        IPage page = this.service.queryPage(param, false);
        return CommonResponse.success((Object)page.getTotal());
    }

    public void send(InfoRegisterEntity entity) {
        ArrayList<String> strings1 = new ArrayList<String>();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("\u5b59\u6653\u4e00\u6d4b\u8bd5");
        CommonResponse allUserByRoleNameList = this.iUserApi.findAllUserByRoleNameList(strings);
        if (allUserByRoleNameList.getCode() == 0) {
            List data = (List)allUserByRoleNameList.getData();
            for (UserVO userVO : data) {
                strings1.add(userVO.getId() + "");
            }
        }
        String[] strings2 = strings1.toArray(new String[strings1.size()]);
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        parameter.setReceivers(strings2);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject("\u6848\u4ef6\u7f16\u53f7\uff1a" + entity.getCaseName() + "\uff0c\u6709\u4e86\u65b0\u7684\u8fdb\u5c55\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff01");
        parameter.setContent("\u6848\u4ef6\u7f16\u53f7\uff1a000000000\uff0c\u63d0\u4ea4\u4e86\u65b0\u7684\u5185\u5bb9\uff01");
        parameter.setPcUrl("/ejc-law-frontend/#/infoRegister/card?id=" + entity.getId());
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", (Object)1000038);
        weixineeParams.put("secret", (Object)"0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE");
        weixineeParams.put("msgtype", (Object)"textcard");
        weixineeParams.put("title", (Object)"\u6848\u4ef6\u6d88\u606f\u901a\u77e5");
        weixineeParams.put("description", (Object)"description");
        weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
        parameter.setWeixineeParams(weixineeParams);
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
        } else {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
        }
    }

    public void updateCaseRegister(InfoRegisterEntity entity) {
        CaseRegisteEntity caseRegisteEntity = (CaseRegisteEntity)((Object)this.caseRegisterService.getById(entity.getCaseId()));
        caseRegisteEntity.setHearCount(entity.getHearCount());
        caseRegisteEntity.setFirstResultId(entity.getFirstResultId());
        caseRegisteEntity.setFirstResultName(entity.getFirstResultName());
        caseRegisteEntity.setFirstEndDate(entity.getFirstEndDate());
        caseRegisteEntity.setFirstEndAmount(entity.getFirstEndAmount());
        this.caseRegisterService.saveOrUpdate((Object)caseRegisteEntity);
    }

    private void ledgerSaveOrUpdate(InfoRegisterEntity entity) {
        LedgerEntity ledgerEntity = (LedgerEntity)((Object)this.ledgerService.getOne((Wrapper)Wrappers.lambdaQuery().eq(LedgerEntity::getCaseId, (Object)entity.getCaseId())));
        if (ledgerEntity != null) {
            ledgerEntity.setId(ledgerEntity.getId());
            ledgerEntity.setCaseResultId(entity.getFirstResultId());
            ledgerEntity.setCaseResultName(entity.getFirstResultName());
            ledgerEntity.setEndAmount(entity.getFirstEndAmount());
            ledgerEntity.setEndDate(entity.getFirstEndDate());
            ledgerEntity.setInfoId(entity.getId());
        }
        this.ledgerService.saveOrUpdate((Object)ledgerEntity);
    }
}

