package com.ejianc.business.law.controller;

import java.io.Serializable;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.desktop.api.IBpmMessageApi;
import com.ejianc.business.desktop.vo.BpmSendMessageVO;
import com.ejianc.business.law.bean.*;
import com.ejianc.business.law.service.IInfoRegisterService;
import com.ejianc.business.law.service.ILedgerService;
import com.ejianc.foundation.message.api.IMessageApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.law.service.ICaseRegisteService;
import com.ejianc.business.law.vo.CaseRegisteVO;

/**
 * 案件登记表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("caseRegiste")
public class CaseRegisteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBpmMessageApi bpmMessageApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICaseRegisteService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IInfoRegisterService infoRegisterService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CaseRegisteVO> saveOrUpdate(@RequestBody CaseRegisteVO saveOrUpdateVO) {
    	CaseRegisteEntity entity = BeanMapper.map(saveOrUpdateVO, CaseRegisteEntity.class);
        UserContext userContextCache =sessionManager.getUserContext();
        if(entity.getId() == null || entity.getId() == 0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }

        List<PartyEntity> partyList = entity.getPartyList();
        String a = "";//原告
        String b = "";//其他被告
        String c = "";//第三人
        for (PartyEntity partyEntity:partyList){
            if ("原告".equals(partyEntity.getPartyTypeName())){
                if ("".equals(a)) {
                    a = a +partyEntity.getPartyName();
                }else {
                    a = a + ","+ partyEntity.getPartyName();
                }
            }else if ("其他被告".equals(partyEntity.getPartyTypeName())){
                if ("".equals(b)) {
                    b = b +partyEntity.getPartyName();
                }else {
                    b = b + ","+ partyEntity.getPartyName();
                }
            }else if ("第三人".equals(partyEntity.getPartyTypeName())){
                if ("".equals(c)) {
                    c = c +partyEntity.getPartyName();
                }else {
                    c = c + ","+ partyEntity.getPartyName();
                }
            }
        }
        entity.setPlaintiffOtherName(a);//其他原告-》原告
        entity.setDefendantOtherName(b);//其他被告
        entity.setDefendantMainName(c);//主被告-》第三人

        //案件编号自动转换为大写
        String upperCase = entity.getCaseCode().toUpperCase();
        entity.setCaseCode(upperCase);

        service.saveOrUpdate(entity, false);


    	CaseRegisteVO vo = BeanMapper.map(entity, CaseRegisteVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CaseRegisteVO> queryDetail(Long id) {
    	CaseRegisteEntity entity = service.selectById(id);
    	if(entity == null){
            return CommonResponse.error("无此条数据！");
        }
    	//查找新项
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("case_id",new Parameter(QueryParam.EQ,id));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        List<InfoRegisterEntity> infoRegisterEntities = infoRegisterService.queryList(param);
        //封装一审二审三审信息
        for (InfoRegisterEntity infoRegisterEntity : infoRegisterEntities){
            if (infoRegisterEntity.getHearCount() == 1){
                entity.setFirstCourtId(infoRegisterEntity.getFirstCourtId());
                entity.setFirstCourtName(infoRegisterEntity.getFirstCourtName());
                entity.setFirstJudgeName(infoRegisterEntity.getFirstJudgeName());
                entity.setFirstJudgeCode(infoRegisterEntity.getFirstJudgeCode());
                entity.setFirstStartDate(infoRegisterEntity.getFirstStartDate());
                entity.setFirstCode(infoRegisterEntity.getFirstCode());
                entity.setFirstTypeId(infoRegisterEntity.getFirstTypeId());
                entity.setFirstTypeName(infoRegisterEntity.getFirstTypeName());
                entity.setFirstEndDate(infoRegisterEntity.getFirstEndDate());
                entity.setFirstEndAmount(infoRegisterEntity.getFirstEndAmount());
                entity.setFirstResultId(infoRegisterEntity.getFirstResultId());
                entity.setFirstResultName(infoRegisterEntity.getFirstResultName());
                entity.setFirstAppealDate(infoRegisterEntity.getFirstAppealDate());
                entity.setFirstLastDate(infoRegisterEntity.getFirstLastDate());

            }else if (infoRegisterEntity.getHearCount() == 2){
                entity.setSecondCourtId(infoRegisterEntity.getFirstCourtId());
                entity.setSecondCourtName(infoRegisterEntity.getFirstCourtName());
                entity.setSecondJudgeName(infoRegisterEntity.getFirstJudgeName());
                entity.setSecondJudgeCode(infoRegisterEntity.getFirstJudgeCode());
                entity.setSecondStartDate(infoRegisterEntity.getFirstStartDate());
                entity.setSecondCode(infoRegisterEntity.getFirstCode());
                entity.setSecondTypeId(infoRegisterEntity.getFirstTypeId());
                entity.setSecondTypeName(infoRegisterEntity.getFirstTypeName());
                entity.setSecondEndDate(infoRegisterEntity.getFirstEndDate());
                entity.setSecondEndAmount(infoRegisterEntity.getFirstEndAmount());
                entity.setSecondResultId(infoRegisterEntity.getFirstResultId());
                entity.setSecondResultName(infoRegisterEntity.getFirstResultName());
                entity.setSecondAppealDate(infoRegisterEntity.getFirstAppealDate());
                entity.setSecondLastDate(infoRegisterEntity.getFirstLastDate());
                entity.setSecondAmount(infoRegisterEntity.getAppealAmount());
            }else if (infoRegisterEntity.getHearCount() == 3){
                entity.setThirdCourtId(infoRegisterEntity.getFirstCourtId());
                entity.setThirdCourtName(infoRegisterEntity.getFirstCourtName());
                entity.setThirdJudgeName(infoRegisterEntity.getFirstJudgeName());
                entity.setThirdJudgeCode(infoRegisterEntity.getFirstJudgeCode());
                entity.setThirdStartDate(infoRegisterEntity.getFirstStartDate());
                entity.setThirdCode(infoRegisterEntity.getFirstCode());
                entity.setThirdTypeId(infoRegisterEntity.getFirstTypeId());
                entity.setThirdTypeName(infoRegisterEntity.getFirstTypeName());
                entity.setThirdEndDate(infoRegisterEntity.getFirstEndDate());
                entity.setThirdEndAmount(infoRegisterEntity.getFirstEndAmount());
                entity.setThirdResultId(infoRegisterEntity.getFirstResultId());
                entity.setThirdResultName(infoRegisterEntity.getFirstResultName());
                entity.setThirdAppealDate(infoRegisterEntity.getFirstAppealDate());
                entity.setThirdAmount(infoRegisterEntity.getThirdAmount());
            }
        }

        CaseRegisteVO vo = BeanMapper.map(entity, CaseRegisteVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CaseRegisteVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CaseRegisteVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CaseRegisteVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CaseRegisteVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("caseCode");
        fuzzyFields.add("departmentName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("disputeTypeName");
        fuzzyFields.add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
                //普通组织
                commonOrgIds.add(org.getId());

        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        param.getOrderMap().put("hearCount",QueryParam.ASC);
        IPage<CaseRegisteEntity> page = service.queryPage(param,false);
        IPage<CaseRegisteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CaseRegisteVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CaseRegisteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CaseRegiste-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refCaseRegisteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CaseRegisteVO>> refCaseRegisteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("departmentName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("caseCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime",QueryParam.DESC);

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            String hearCount = con.getString("hearCount");
            if (StringUtils.isNotEmpty(hearCount)){
                if (hearCount.equals("1")){
                    param.getParams().put("hearCount", new Parameter(QueryParam.EQ, 0));
                }else if (hearCount.equals("2")){
                    param.getParams().put("hearCount", new Parameter(QueryParam.EQ, 1));
                }else {
                    param.getParams().put("hearCount", new Parameter(QueryParam.EQ, 2));
                }
            }
        }

        IPage<CaseRegisteEntity> page = service.queryPage(param,false);
        IPage<CaseRegisteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CaseRegisteVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description 纠纷类型
     * @param
     * @Return void
     */
    @RequestMapping(value = "/DisputeTypeData", method = RequestMethod.GET)
    @ResponseBody
    public JSONArray DisputeTypeData() {

        String str = "[{\n" +
                "\t\"value\": \"1\",\n" +
                "\t\"title\": \"买卖合同纠纷\",\n" +
                "\t\"label\": \"买卖合同纠纷\",\n" +
                "\t\"children\": []\n" +
                "}, {\n" +
                "\t\"value\": \"2\",\n" +
                "\t\"title\": \"租赁合同纠纷\",\n" +
                "\t\"label\": \"租赁合同纠纷\",\n" +
                "\t\"children\": []\n" +
                "}, {\n" +
                "\t\"value\": \"3\",\n" +
                "\t\"title\": \"建设工程合同纠纷\",\n" +
                "\t\"label\": \"建设工程合同纠纷\",\n" +
                "\t\"children\": []\n" +
                "}, {\n" +
                "\t\"value\": \"4\",\n" +
                "\t\"title\": \"劳务类纠纷\",\n" +
                "\t\"label\": \"劳务类纠纷\",\n" +
                "\t\"children\": [{\n" +
                "\t\t\"value\": \"41\",\n" +
                "\t\t\"title\": \"劳务合同纠纷\",\n" +
                "\t\t\"label\": \"劳务合同纠纷\",\n" +
                "\t\t\"children\": []\n" +
                "\t}, {\n" +
                "\t\t\"value\": \"42\",\n" +
                "\t\t\"title\": \"追索劳动报酬纠纷\",\n" +
                "\t\t\"label\": \"追索劳动报酬纠纷\",\n" +
                "\t\t\"children\": []\n" +
                "\t}, {\n" +
                "\t\t\"value\": \"43\",\n" +
                "\t\t\"title\": \"提供劳务者受害责任纠纷\",\n" +
                "\t\t\"label\": \"提供劳务者受害责任纠纷\",\n" +
                "\t\t\"children\": []\n" +
                "\t}, {\n" +
                "\t\t\"value\": \"44\",\n" +
                "\t\t\"title\": \"劳动争议（员工）\",\n" +
                "\t\t\"label\": \"劳动争议（员工）\",\n" +
                "\t\t\"children\": []\n" +
                "\t},{\n" +
                "\t\t\"value\": \"45\",\n" +
                "\t\t\"title\": \"劳动争议（工伤）\",\n" +
                "\t\t\"label\": \"劳动争议（工伤）\",\n" +
                "\t\t\"children\": []\n" +
                "\t}]\n" +
                "}, {\n" +
                "\t\"value\": \"5\",\n" +
                "\t\"title\": \"民间借贷纠纷\",\n" +
                "\t\"label\": \"民间借贷纠纷\",\n" +
                "\t\"children\": []\n" +
                "}, {\n" +
                "\t\"value\": \"6\",\n" +
                "\t\"title\": \"承揽合同纠纷\",\n" +
                "\t\"label\": \"承揽合同纠纷\",\n" +
                "\t\"children\": []\n" +
                "}, {\n" +
                "\t\"value\": \"7\",\n" +
                "\t\"title\": \"其他类纠纷\",\n" +
                "\t\"label\": \"其他类纠纷\",\n" +
                "\t\"children\": [{\n" +
                "\t\t\"value\": \"71\",\n" +
                "\t\t\"title\": \"债权转让纠纷\",\n" +
                "\t\t\"label\": \"债权转让纠纷\",\n" +
                "\t\t\"children\": []\n" +
                "\t}, {\n" +
                "\t\t\"value\": \"72\",\n" +
                "\t\t\"title\": \"追偿权纠纷\",\n" +
                "\t\t\"label\": \"追偿权纠纷\",\n" +
                "\t\t\"children\": []\n" +
                "\t}, {\n" +
                "\t\t\"value\": \"73\",\n" +
                "\t\t\"title\": \"不当得利纠纷\",\n" +
                "\t\t\"label\": \"不当得利纠纷\",\n" +
                "\t\t\"children\": []\n" +
                "\t}, {\n" +
                "\t\t\"value\": \"74\",\n" +
                "\t\t\"title\": \"返还原物纠纷\",\n" +
                "\t\t\"label\": \"返还原物纠纷\",\n" +
                "\t\t\"children\": []\n" +
                "\t}, {\n" +
                "\t\t\"value\": \"75\",\n" +
                "\t\t\"title\": \"行政诉讼\",\n" +
                "\t\t\"label\": \"行政诉讼\",\n" +
                "\t\t\"children\": []\n" +
                "\t}]\n" +
                "}]";
        return  JSONObject.parseArray(str);
    }

    /**
     * 案件台账关联更新
     */
    @Autowired
    private ILedgerService ledgerService;

    private void ledgerSaveOrUpdate(CaseRegisteEntity entity){
        LedgerEntity ledgerEntity = ledgerService.getOne(Wrappers.<LedgerEntity>lambdaQuery().eq(LedgerEntity::getCaseId, entity.getId()));
        if(ledgerEntity != null){
            ledgerEntity.setCaseId(entity.getId());//案件编号
            ledgerEntity.setCaseCode(entity.getCaseCode());
            ledgerEntity.setEndDate(entity.getCognizanceDate());//收案日期
            ledgerEntity.setSueAmount(entity.getSueAmount());//起诉金额
            ledgerEntity.setDepartmentName(entity.getDepartmentName());//涉案项目部
            ledgerEntity.setProjectName(entity.getProjectName());//工程
            ledgerEntity.setDisputeType(entity.getDisputeType());//纠纷类型
            ledgerEntity.setDisputeTypeName(entity.getDisputeTypeName());
            ledgerEntity.setCaseState(entity.getCaseState());//案件状态
            ledgerEntity.setCaseStateName(entity.getCaseStateName());
            ledgerEntity.setPayState(entity.getPayState());//付款状态
            ledgerEntity.setPayStateName(entity.getPayStateName());
            ledgerEntity.setPlaintiffId(entity.getPlaintiffMainId());//原告
            ledgerEntity.setPlaintiffName(entity.getPlaintiffMainName());
            ledgerEntity.setOtherDefendantId(entity.getDefendantOtherId());//其他被告
            ledgerEntity.setOtherDefendantName(entity.getDefendantOtherName());
            ledgerEntity.setThirdPartyId(entity.getDefendantMainId());//第三人
            ledgerEntity.setThirdPartyName(entity.getDefendantMainName());
            ledgerService.saveOrUpdate(ledgerEntity);
        } else{
            LedgerEntity newEntity = new LedgerEntity();
            newEntity.setCaseId(entity.getId());//案件编号
            newEntity.setCaseCode(entity.getCaseCode());
            newEntity.setEndDate(entity.getCognizanceDate());//收案日期
            newEntity.setSueAmount(entity.getSueAmount());//起诉金额
            newEntity.setDepartmentName(entity.getDepartmentName());//涉案项目部
            newEntity.setProjectName(entity.getProjectName());//工程
            newEntity.setDisputeType(entity.getDisputeType());//纠纷类型
            newEntity.setDisputeTypeName(entity.getDisputeTypeName());
            newEntity.setCaseState(entity.getCaseState());//案件状态
            newEntity.setCaseStateName(entity.getCaseStateName());
            newEntity.setPayState(entity.getPayState());//付款状态
            newEntity.setPayStateName(entity.getPayStateName());
            newEntity.setPlaintiffId(entity.getPlaintiffMainId());//原告
            newEntity.setPlaintiffName(entity.getPlaintiffMainName());
            newEntity.setOtherDefendantId(entity.getDefendantOtherId());//其他被告
            newEntity.setOtherDefendantName(entity.getDefendantOtherName());
            newEntity.setThirdPartyId(entity.getDefendantMainId());//第三人
            newEntity.setThirdPartyName(entity.getDefendantMainName());
            ledgerService.saveOrUpdate(newEntity);
        }



    }

    /**
     * @Description queryMessageList 消息已读回执
     * @param param
     */
    @RequestMapping(value = "/queryMessageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BpmSendMessageVO>> queryMessageList(@RequestBody QueryParam param) {

        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        String billCode = param.getParams().get("billCode").getValue().toString();
        String billTypeName = param.getParams().get("billTypeName").getValue().toString();
        CommonResponse<List<BpmSendMessageVO>> bpmMessage = bpmMessageApi.queryBpmMessage(billCode,billTypeName);
        if(bpmMessage.isSuccess()){
            List<BpmSendMessageVO> bpmSendMessageVOS = bpmMessage.getData();
            int curIdx = pageIndex > 1 ? (pageIndex - 1) * pageSize : 0;
            List<BpmSendMessageVO> result = new ArrayList<>();
            for(int i = 0; curIdx + i < bpmSendMessageVOS.size() && curIdx + i < pageIndex*pageSize; i++) {
                if (ObjectUtil.isNotEmpty(bpmSendMessageVOS.get(curIdx + i))) {
                    result.add(bpmSendMessageVOS.get(curIdx + i));
                }
            }
            IPage<BpmSendMessageVO> page = new Page<>(pageIndex,pageSize,bpmSendMessageVOS.size());
            page.setRecords(result);
            return CommonResponse.success("查询数据成功！",page);
        } else {
            return CommonResponse.error("远程结构调用失败！");
        }

    }



}
