package com.ejianc.business.law.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.law.bean.*;
import com.ejianc.business.law.service.ICaseRegisteService;
import com.ejianc.business.law.service.IFrozenFundZiService;
import com.ejianc.business.law.service.ILedgerService;
import com.ejianc.business.law.vo.CaseFrozenVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.law.service.IFrozenFundService;
import com.ejianc.business.law.vo.FrozenFundVO;

/**
 * 资金冻结单
 *
 * @author generator
 */
@Controller
@RequestMapping("frozenFund")
public class FrozenFundController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFrozenFundService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FrozenFundVO> saveOrUpdate(@RequestBody FrozenFundVO saveOrUpdateVO) {
        FrozenFundEntity entity = BeanMapper.map(saveOrUpdateVO, FrozenFundEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0) {
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }


        service.saveOrUpdate(entity, false);

//        //案件台账关联更新
//        ledgerSaveOrUpdate(entity);
        //案件登记关联更新
        caseRegisteSaveOrUpdate(entity);

        FrozenFundVO vo = BeanMapper.map(entity, FrozenFundVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FrozenFundVO> queryDetail(Long id) {
        FrozenFundEntity entity = service.selectById(id);
        FrozenFundVO vo = BeanMapper.map(entity, FrozenFundVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FrozenFundVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FrozenFundVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FrozenFundVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FrozenFundVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<FrozenFundEntity> page = service.queryPage(param, false);
        IPage<FrozenFundVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FrozenFundVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FrozenFundEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FrozenFund-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refFrozenFundData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FrozenFundVO>> refFrozenFundData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FrozenFundEntity> page = service.queryPage(param, false);
        IPage<FrozenFundVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FrozenFundVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @RequestMapping(value = "/queryFrozenFund", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FrozenFundVO> queryFrozenFund(Long caseId) {
        FrozenFundEntity entity = service.getOne(Wrappers.<FrozenFundEntity>lambdaQuery().eq(FrozenFundEntity::getCaseId, caseId));
        FrozenFundVO vo = BeanMapper.map(entity, FrozenFundVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 案件冻结详情
     *
     * @param caseId
     * @return
     */
    @Autowired
    private IFrozenFundZiService frozenFundZiService;

    @RequestMapping(value = "/queryCaseFrozen", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CaseFrozenVO>> queryCaseFrozen(Long caseId) {
        List<CaseFrozenVO> caseFrozenVOS = new ArrayList<>();
        if (caseId != null) {
            List<FrozenFundEntity> list = service.list(Wrappers.<FrozenFundEntity>lambdaQuery().
                    eq(FrozenFundEntity::getCaseId, caseId));
            //遍历冻结主表
            for (FrozenFundEntity frozenFundEntity : list) {
                //根据主表id查询冻结子表信息
                Long id = frozenFundEntity.getId();
                List<FrozenFundZiEntity> ziList = frozenFundZiService.list(Wrappers.<FrozenFundZiEntity>lambdaQuery().
                        eq(FrozenFundZiEntity::getZhuId, id));
                //遍历冻结子表封装VO
                for (FrozenFundZiEntity frozenFundZiEntity : ziList) {
                    CaseFrozenVO map = BeanMapper.map(frozenFundZiEntity, CaseFrozenVO.class);
                    map.setMainFrozenDate(frozenFundEntity.getFrozenDate());
                    map.setFrozenCode(frozenFundEntity.getFrozenCode());
                    caseFrozenVOS.add(map);
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！", caseFrozenVOS);
    }

    /**
     * 案件台账关联更新
     */
    @Autowired
    private ILedgerService ledgerService;

    private void ledgerSaveOrUpdate(FrozenFundEntity entity) {
        LedgerEntity ledgerEntity = ledgerService.getOne(Wrappers.<LedgerEntity>lambdaQuery().eq(LedgerEntity::getCaseId, entity.getCaseId()));
        if (ledgerEntity != null) {
            ledgerEntity.setFrozenId(entity.getId());//冻结id、编号
            ledgerEntity.setFrozenCode(entity.getFrozenCode());
            ledgerService.saveOrUpdate(ledgerEntity);
        } else {
            logger.info("案件台账中无此条数据，case:{}", entity.getId());
        }
    }

    /**
     * 案件登记关联更新
     */
    @Autowired
    private ICaseRegisteService caseRegisteService;

    private void caseRegisteSaveOrUpdate(FrozenFundEntity entity) {
        CaseRegisteEntity caseRegisteEntity = caseRegisteService.getOne(Wrappers.<CaseRegisteEntity>lambdaQuery().eq(CaseRegisteEntity::getId, entity.getCaseId()));
        if (caseRegisteEntity != null) {
            caseRegisteEntity.setFrozenId(entity.getId());//冻结id、编号
            caseRegisteEntity.setFrozenCode(entity.getFrozenCode());
            caseRegisteEntity.setTotalFrozenAmount(entity.getFrozenPrice());//冻结总金额
            caseRegisteService.saveOrUpdate(caseRegisteEntity);
        } else {
            logger.info("案件登记中无此条数据,id:{}", entity.getCaseId());
        }
    }
}
