package com.ejianc.business.base.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 适配比子表
 * 
 * @author generator
 * 
 */
public class ProductMixDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private String name; // 运输商名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String operatorId; // 经办人id
    private String operatorName; // 经办人名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private Long mixId; // 配合比主键
    private Long materialCategoryId; // 材料类别主键
    private Long materialVarietyId; // 材料品种主键
    private Long materialSpecId; // 材料型号主键
    private BigDecimal percent; // 百分比
    private Integer admixtures; // 外加剂必填(1:是,0:否)
    private String sortCode; // 序号
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ReferSerialTransfer(referCode="idm-user")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public String getOperatorId() {
        return operatorId;
    }
    @ReferDeserialTransfer
    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public Long getMixId() {
        return mixId;
    }

    public void setMixId(Long mixId) {
        this.mixId = mixId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public Long getMaterialVarietyId() {
        return materialVarietyId;
    }

    public void setMaterialVarietyId(Long materialVarietyId) {
        this.materialVarietyId = materialVarietyId;
    }
    public Long getMaterialSpecId() {
        return materialSpecId;
    }

    public void setMaterialSpecId(Long materialSpecId) {
        this.materialSpecId = materialSpecId;
    }
    public BigDecimal getPercent() {
        return percent;
    }

    public void setPercent(BigDecimal percent) {
        this.percent = percent;
    }
    public Integer getAdmixtures() {
        return admixtures;
    }

    public void setAdmixtures(Integer admixtures) {
        this.admixtures = admixtures;
    }
    public String getSortCode() {
        return sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }
    
}
