/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.CustomercategoryEntity;
import com.ejianc.business.base.bean.CustomermanageEntity;
import com.ejianc.business.base.service.ICustomercategoryService;
import com.ejianc.business.base.service.ICustomermanageService;
import com.ejianc.business.base.vo.CustomermanageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"customerExcel"})
public class ExcelCustomerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICustomermanageService service;
    @Autowired
    private ICustomercategoryService categoryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "custom-manage";

    @RequestMapping(value={"/downloadCustomermanage"})
    @ResponseBody
    public void downloadMaterialrequirement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"customer-import.xlsx", (String)"\u5ba2\u6237\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportCustomermanage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialrequirement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<CustomermanageVO> successList = new ArrayList<CustomermanageVO>();
        ArrayList<CustomermanageVO> errorList = new ArrayList<CustomermanageVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                CustomermanageVO VO = new CustomermanageVO();
                VO.setId(IdWorker.getId());
                VO.setName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setCategoryName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? (String)data.get(1) : null);
                VO.setAbbname(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? (String)data.get(2) : null);
                VO.setLegalPerson(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setCorporatePhone(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? (String)data.get(4) : null);
                VO.setCorporateIdNumber(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(5))) ? (String)data.get(5) : null);
                VO.setLicenseCode(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(6))) ? (String)data.get(6) : null);
                VO.setRegisteredCapital(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(7))) ? (String)data.get(7) : null);
                VO.setAddress(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(8))) ? (String)data.get(8) : null);
                VO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(9))) ? (String)data.get(9) : null);
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u5ba2\u6237\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"name", data.get(0));
                query.eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId());
                CustomermanageEntity entity = (CustomermanageEntity)((Object)this.service.getOne((Wrapper)query));
                if (entity != null && (entity.getId() != null || entity.getId() != 0L)) {
                    VO.setErrorMsg("\u67e5\u91cd\u6821\u9a8c:" + (String)data.get(0) + "\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u5ba2\u6237\u5206\u7c7b'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(1));
                CustomercategoryEntity cateEntity = (CustomercategoryEntity)((Object)this.categoryService.getOne((Wrapper)query));
                if (cateEntity == null) {
                    VO.setErrorMsg("\u5ba2\u6237\u5206\u7c7b\u5e93\u672a\u67e5\u627e\u5230\u5ba2\u6237\u5206\u7c7b\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                VO.setCategoryId(cateEntity.getId());
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List customermanageEntities = BeanMapper.mapList(successList, CustomermanageEntity.class);
                for (CustomermanageEntity entity : customermanageEntities) {
                    CustomermanageVO VO = (CustomermanageVO)((Object)BeanMapper.map((Object)((Object)entity), CustomermanageVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setCode((String)billCode.getData());
                }
                this.service.saveOrUpdateBatch(customermanageEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

