/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.MaterialVarietiesEntity;
import com.ejianc.business.base.bean.ProductCategoryEntity;
import com.ejianc.business.base.bean.ProductEntity;
import com.ejianc.business.base.bean.ProductGradeEntity;
import com.ejianc.business.base.bean.ProductSpecEntity;
import com.ejianc.business.base.service.IMaterialVarietiesService;
import com.ejianc.business.base.service.IProductCategoryService;
import com.ejianc.business.base.service.IProductGradeService;
import com.ejianc.business.base.service.IProductService;
import com.ejianc.business.base.service.IProductSpecService;
import com.ejianc.business.base.vo.ProductVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"productExport"})
public class ExcelProductController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProductService service;
    @Autowired
    private IProductCategoryService categoryService;
    @Autowired
    private IProductGradeService gradeService;
    @Autowired
    private IProductSpecService specService;
    @Autowired
    private IMaterialVarietiesService materialVarietiesService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "base-product";

    @RequestMapping(value={"/downloadProduct"})
    @ResponseBody
    public void downloadProduct(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"product-import.xlsx", (String)"\u4ea7\u54c1\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportProduct"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportProduct(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ProductVO> successList = new ArrayList<ProductVO>();
        ArrayList<ProductVO> errorList = new ArrayList<ProductVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                ProductVO VO = new ProductVO();
                VO.setId(IdWorker.getId());
                VO.setCategoryName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setSpecName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? (String)data.get(1) : null);
                VO.setGradeName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? (String)data.get(2) : null);
                VO.setAsphaltName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setStoneName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? (String)data.get(4) : null);
                VO.setName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(5))) ? (String)data.get(5) : null);
                VO.setAlias(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(6))) ? (String)data.get(6) : null);
                VO.setComprehensiveUtilizationName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(7))) ? (String)data.get(7) : null);
                VO.setTaxRate(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(8))) ? new BigDecimal((String)data.get(8)) : null);
                VO.setSuggestedPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(9))) ? new BigDecimal((String)data.get(9)) : null);
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u4ea7\u54c1\u7c7b\u522b'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"name", data.get(0));
                ProductCategoryEntity entity = (ProductCategoryEntity)((Object)this.categoryService.getOne((Wrapper)query));
                if (entity == null && entity.getId() == null) {
                    VO.setErrorMsg("\u4ea7\u54c1\u5206\u7c7b\u5e93\u672a\u67e5\u627e\u5230\u6b64\u5206\u7c7b\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                VO.setCategoryId(entity.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u4ea7\u54c1\u89c4\u683c'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(1));
                ProductSpecEntity spec = (ProductSpecEntity)((Object)this.specService.getOne((Wrapper)query));
                if (spec == null || spec.getId() == null) {
                    VO.setErrorMsg("\u4ea7\u54c1\u89c4\u683c\u5e93\u672a\u67e5\u627e\u5230\u6b64\u89c4\u683c\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                VO.setSpecId(spec.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(2))) || data.get(2) == null) {
                    VO.setErrorMsg("'\u4ea7\u54c1\u7ea7\u914d'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(2));
                ProductGradeEntity grade = (ProductGradeEntity)((Object)this.gradeService.getOne((Wrapper)query));
                if (grade == null || grade.getId() == null) {
                    VO.setErrorMsg("\u4ea7\u54c1\u7ea7\u914d\u5e93\u672a\u67e5\u627e\u5230\u6b64\u7ea7\u914d\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                VO.setGradeId(grade.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(3))) || data.get(3) == null) {
                    VO.setErrorMsg("'\u6ca5\u9752'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(3));
                MaterialVarietiesEntity asphalt = (MaterialVarietiesEntity)((Object)this.materialVarietiesService.getOne((Wrapper)query));
                if (asphalt == null || asphalt.getId() == null) {
                    VO.setErrorMsg("\u6750\u6599\u54c1\u79cd\u5e93\u672a\u67e5\u627e\u5230\u6b64\u6ca5\u9752\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                VO.setAsphaltId(asphalt.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(4))) || data.get(4) == null) {
                    VO.setErrorMsg("'\u77f3\u6599'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(4));
                MaterialVarietiesEntity stone = (MaterialVarietiesEntity)((Object)this.materialVarietiesService.getOne((Wrapper)query));
                if (stone == null || stone.getId() == null) {
                    VO.setErrorMsg("\u6750\u6599\u54c1\u79cd\u5e93\u672a\u67e5\u627e\u5230\u6b64\u77f3\u6599\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                VO.setStoneId(stone.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(5))) || data.get(5) == null) {
                    VO.setErrorMsg("'\u4ea7\u54c1\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(5));
                ProductEntity product = (ProductEntity)((Object)this.service.getOne((Wrapper)query));
                if (product != null && product.getId() != null) {
                    VO.setErrorMsg("\u67e5\u91cd\u6821\u9a8c:'\u4ea7\u54c1\u540d\u79f0'\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List productEntities = BeanMapper.mapList(successList, ProductEntity.class);
                for (ProductEntity entity : productEntities) {
                    ProductVO VO = (ProductVO)((Object)BeanMapper.map((Object)((Object)entity), ProductVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveOrUpdateBatch(productEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

