/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.ShippersEntity;
import com.ejianc.business.base.bean.ShippersVehicleEntity;
import com.ejianc.business.base.service.IShippersService;
import com.ejianc.business.base.service.IShippersVehicleService;
import com.ejianc.business.base.vo.ShippersVehicleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"shippersVehicleExport"})
public class ExcelShippersVehicleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IShippersVehicleService service;
    @Autowired
    private IShippersService shippersService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "shippers-vehicle";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/downloadShippersVehicle"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"shippersvehicle-import.xlsx", (String)"\u8fd0\u8f93\u5546\u8f66\u8f86\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportShippersVehicle"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ShippersVehicleVO> successList = new ArrayList<ShippersVehicleVO>();
        ArrayList<ShippersVehicleVO> errorList = new ArrayList<ShippersVehicleVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            ShippersVehicleVO VO;
            for (int i = 1; i < result.size(); ++i) {
                Long orgId = InvocationInfoProxy.getOrgId();
                List data = (List)result.get(i);
                VO = new ShippersVehicleVO();
                VO.setId(IdWorker.getId());
                VO.setName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setShipperMName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? (String)data.get(1) : null);
                VO.setPlateNumber(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? (String)data.get(2) : null);
                VO.setGreenPlate(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setTare(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? new BigDecimal((String)data.get(4)) : null);
                VO.setTonnage(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(5))) ? new BigDecimal((String)data.get(5)) : null);
                VO.setVehicleExplain(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(6))) ? (String)data.get(6) : null);
                VO.setDriver(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(7))) ? (String)data.get(7) : null);
                VO.setDriverPhone(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(8))) ? (String)data.get(8) : null);
                VO.setDriverWx(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(9))) ? (String)data.get(9) : null);
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u8fd0\u8f93\u5546\u8f66\u8f86\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u8fd0\u8f93\u5546\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"name", data.get(1));
                query.eq((Object)"org_id", (Object)orgId);
                BaseEntity entity = (ShippersEntity)((Object)this.shippersService.getOne((Wrapper)query));
                if (entity == null) {
                    VO.setErrorMsg("\u8fd0\u8f93\u5546\u5e93\u672a\u67e5\u627e\u5230\u8fd0\u8f93\u5546\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                VO.setShipperMId(entity.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(2))) || data.get(2) == null) {
                    VO.setErrorMsg("'\u8f66\u724c\u53f7'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"plate_number", data.get(2));
                query.eq((Object)"org_id", (Object)orgId);
                entity = (ShippersVehicleEntity)((Object)this.service.getOne((Wrapper)query));
                if (entity != null) {
                    VO.setErrorMsg("\u67e5\u91cd\u6821\u9a8c:'\u8f66\u724c\u53f7'\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(3))) || data.get(3) == null) {
                    VO.setErrorMsg("'\u662f\u5426\u7eff\u724c'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                if ("\u662f".equals(data.get(3))) {
                    VO.setGreenPlate("0");
                } else if ("\u5426".equals(data.get(3))) {
                    VO.setGreenPlate("1");
                } else {
                    VO.setErrorMsg("'\u662f\u5426\u7eff\u724c'\u53ea\u80fd\u4e3a'\u662f'\u6216\u8005'\u5426'");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(4))) || data.get(4) == null) {
                    VO.setErrorMsg("'\u76ae\u91cd'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(7))) || data.get(7) == null) {
                    VO.setErrorMsg("'\u53f8\u673a\u59d3\u540d'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(7))) || data.get(7) == null) {
                    VO.setErrorMsg("'\u53f8\u673a\u624b\u673a'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List shippersVehicleEntities = BeanMapper.mapList(successList, ShippersVehicleEntity.class);
                for (ShippersVehicleEntity entity : shippersVehicleEntities) {
                    VO = (ShippersVehicleVO)((Object)BeanMapper.map((Object)((Object)entity), ShippersVehicleVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveOrUpdateBatch(shippersVehicleEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

