package com.ejianc.business.base.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.business.base.bases.vo.ShippersfareVO;
import com.ejianc.business.base.bean.ShippersVehicleEntity;
import com.ejianc.business.base.service.IShippersVehicleService;
import com.ejianc.business.base.service.IShippersfareService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/base/baseApi")
public class BaseApi {
    @Autowired
    IShippersVehicleService service;

    @Autowired
    IShippersfareService shippersfareService;
    /**
     * 请求获取生产任务单和运输商，运输商车辆信息
     * @param carCode
     * @return
     */
    @PostMapping(value = "/getshippersinfo")
    public CommonResponse<ShippersInfoApiVO> getShippersInfo(@RequestParam(value = "carCode") String carCode,@RequestParam(value = "orgId") Long orgId){
        ShippersInfoApiVO apiVO = new ShippersInfoApiVO();
        QueryWrapper query=new QueryWrapper();
        query.eq("plate_number",carCode);
        query.eq("org_id",orgId);
        ShippersVehicleEntity entity = service.getOne(query);
        if (entity!=null){
            apiVO.setCarId(entity.getId());
            apiVO.setCarName(entity.getName());
            apiVO.setShipperMId(entity.getShipperMId());
            apiVO.setShipperMName(entity.getShipperMName());
            apiVO.setCategory(entity.getCategory());
            apiVO.setTare(entity.getTare());
            QueryWrapper queryfare=new QueryWrapper();
            queryfare.eq("mid",entity.getShipperMId());
            List<ShippersfareVO> list = shippersfareService.list(queryfare);
            apiVO.setShippersfareVOS(list);
        }else {
            throw new BusinessException("车牌号未查到运输商车辆信息");
        }

        return CommonResponse.success("访问成功！！",apiVO);
    }
    /**
     * 请求获取生产任务单和运输商，运输商车辆信息
     * @param
     * @return
     */
    @GetMapping(value = "/updatestatus")
    public CommonResponse updatestatus(@RequestParam(value = "vehicleId") Long vehicleId,@RequestParam(value = "status") Integer status){
        ShippersVehicleEntity entity = service.selectById(vehicleId);
        if (entity!=null){
            entity.setStatus(status);
            service.saveOrUpdate(entity,false);
        }else{
            return CommonResponse.error("未查找到此车辆");
        }
        return CommonResponse.success("车辆状态更新成功！！");
    }
}
