package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.CustomerbankEntity;
import com.ejianc.business.base.bean.CustomercontactsEntity;
import com.ejianc.business.base.bean.CustomermanageEntity;
import com.ejianc.business.base.service.ICustomercontactsService;
import com.ejianc.business.base.service.ICustomermanageService;
import com.ejianc.business.base.vo.CustomercontactsVO;
import com.ejianc.business.base.vo.CustomermanageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.util.*;

/**
 * 客户联系人信息的导入导出
 */
@Controller
@RequestMapping("customerLinkerExcel")
public class ExcelCustomerLinkerController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private ICustomermanageService customermanageService;
    @Autowired
    private ICustomercontactsService service;

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "custom-lnker";//此处需要根据实际修改

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadCustomerlinker")
    @ResponseBody
    public void downloadCustomerlinker(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "customerlinker-import.xlsx", "客户联系人信息导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportCustomerlinker", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportCustomerlinker(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<CustomercontactsVO> successList = new ArrayList<>();
        List<CustomercontactsVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    CustomercontactsVO VO = new CustomercontactsVO();
                    VO.setId(IdWorker.getId());
                    VO.setCustomName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setContacts(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setPhone(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'客户名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(0));
                        query.eq("org_id",InvocationInfoProxy.getOrgId());
                        CustomermanageEntity entity = customermanageService.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setManagearchivesId(entity.getId());
                        }else {
                            VO.setErrorMsg("客户名称库未查找到客户名称，请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
                        VO.setErrorMsg("'联系人'不能为空！");
                        errorList.add(VO);
                        continue;
                    }
                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
                        VO.setErrorMsg("'手机号'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("phone",data.get(2));
                        query.eq("org_id",InvocationInfoProxy.getOrgId());
                        CustomercontactsEntity entity = service.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setErrorMsg("查重校验:'手机号'已存在，请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }

                    successList.add(VO);
                }
                if (errorList.size()==0) {
                    List<CustomercontactsEntity> customercontactsEntities = BeanMapper.mapList(successList, CustomercontactsEntity.class);
                    for (CustomercontactsEntity entity : customercontactsEntities) {
                        CustomermanageVO VO = BeanMapper.map(entity, CustomermanageVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(customercontactsEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
