package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.*;
import com.ejianc.business.base.service.IMaterialCategoryService;
import com.ejianc.business.base.service.IMaterialService;
import com.ejianc.business.base.service.IMaterialSpecService;
import com.ejianc.business.base.service.IMaterialVarietiesService;
import com.ejianc.business.base.vo.MaterialVO;

import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * 限额设计指标分析导入导出
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialExport")
public class ExcelMaterialController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IMaterialVarietiesService materialVarietiesService;
    @Autowired
    private IMaterialSpecService materialSpecService;
    @Autowired
    private IMaterialService service;

    @Autowired
    private IBillCodeApi billCodeApi;


    private static final String BILL_CODE = "base-material";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
	/********************限额设计指标分析清单表导入导出start**************/
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaterial")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "material-import.xlsx", "原材料导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportMaterial", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialVO> successList = new ArrayList<>();
        List<MaterialVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    MaterialVO VO = new MaterialVO();
                    VO.setId(IdWorker.getId());
                    VO.setCategoryName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setVarietiesName(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setSpecName(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setName(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
                    VO.setTaxAttributesId(StringUtils.isNotBlank(data.get(4)) ? data.get(4) : null);
                    VO.setInspectionModeId(StringUtils.isNotBlank(data.get(5)) ? data.get(5) : null);
                    VO.setDiscountRateId(StringUtils.isNotBlank(data.get(6)) ? new BigDecimal(data.get(6)) : null);
                    VO.setDecimalPlacesId(StringUtils.isNotBlank(data.get(7)) ? new BigDecimal(data.get(7)) : null);
                    VO.setReferencePrice(StringUtils.isNotBlank(data.get(8)) ? new BigDecimal(data.get(8)) : null);
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'材料类别'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(0));
                        MaterialCategoryEntity entity = materialCategoryService.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setCategoryId(entity.getId());
                        }else {
                            VO.setErrorMsg("材料类别库未查找到此材料类别名称，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
                        VO.setErrorMsg("'材料品种'不能为空");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(1));
                        MaterialVarietiesEntity entity = materialVarietiesService.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setVarietiesId(entity.getId());
                        }else{
                            VO.setErrorMsg("材料品种库未查找到此材料品种名称，请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
                        VO.setErrorMsg("'材料规格'不能为空");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(2));
                        MaterialSpecEntity entity = materialSpecService.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setSpecId(entity.getId());
                        }else{
                            VO.setErrorMsg("材料规格库未查找到此材料规格名称，请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(3)) || data.get(3) == null) {
                        VO.setErrorMsg("'原材料名称'不能为空");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(3));
                        MaterialEntity entity = service.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setErrorMsg("查重校验:'原材料名称'已存在，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    successList.add(VO);
                }
                if (errorList.size()==0) {
                    List<MaterialEntity> materialEntities = BeanMapper.mapList(successList, MaterialEntity.class);
                    for (MaterialEntity entity : materialEntities) {
                        MaterialVO VO = BeanMapper.map(entity, MaterialVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(materialEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
