package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.CustomerbankEntity;
import com.ejianc.business.base.bean.CustomermanageEntity;
import com.ejianc.business.base.bean.SupplierbankEntity;
import com.ejianc.business.base.bean.SupplierinfoEntity;
import com.ejianc.business.base.service.ISupplierbankService;
import com.ejianc.business.base.service.ISupplierinfoService;
import com.ejianc.business.base.vo.CustomerbankVO;
import com.ejianc.business.base.vo.SupplierbankVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.util.*;

/**
 * 供应商银行导入
 */
@Controller
@RequestMapping("supplyBankeExport")
public class ExcelSupplyBankController implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ISupplierbankService service;
    @Autowired
    private ISupplierinfoService supplierinfoService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "supply-bank";//此处需要根据实际修改
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadSupplybank")
    @ResponseBody
    public void downloadSupplybank(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "supplybank-import.xlsx", "客户银行信息导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSupplybank", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSupplybank(HttpServletRequest request, HttpServletResponse response){
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SupplierbankVO> successList = new ArrayList<>();
        List<SupplierbankVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    SupplierbankVO VO = new SupplierbankVO();
                    VO.setId(IdWorker.getId());
                    VO.setSupplyName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setSupplyBank(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setSupplyAccount(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'供应商名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("supply_name",data.get(0));
                        query.eq("org_id",InvocationInfoProxy.getOrgId());
                        SupplierinfoEntity entity = supplierinfoService.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setManageId(entity.getId());
                        }else {
                            VO.setErrorMsg("供应商名称库未查找到供应商名称，请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
                        VO.setErrorMsg("'开户银行名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }
                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
                        VO.setErrorMsg("'开户银行账号'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("supply_account",data.get(2));
                        query.eq("org_id",InvocationInfoProxy.getOrgId());
                        SupplierbankEntity entity = service.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setErrorMsg("查重校验:'开户银行账号'已存在，请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    successList.add(VO);
                }
                if (errorList.size()==0) {
                    List<SupplierbankEntity> supplierbankEntitier = BeanMapper.mapList(successList, SupplierbankEntity.class);
                    for (SupplierbankEntity entity : supplierbankEntitier) {
                        SupplierbankVO VO = BeanMapper.map(entity, SupplierbankVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(supplierbankEntitier, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
