package com.ejianc.business.base.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.CustomerbankEntity;
import com.ejianc.business.base.bean.CustomercontactsEntity;
import com.ejianc.business.base.service.ICustomerbankService;
import com.ejianc.business.base.service.ICustomercontactsService;
import com.ejianc.business.base.vo.CustomerbankVO;
import com.ejianc.business.base.vo.CustomercontactsVO;
import com.ejianc.business.base.vo.RequestVO;

import com.ejianc.business.change.bean.ChangeCustomerEntity;
import com.ejianc.business.change.service.IChangeCustomerService;
import com.ejianc.business.change.vo.ChangeCustomerVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.base.bean.CustomermanageEntity;
import com.ejianc.business.base.service.ICustomermanageService;
import com.ejianc.business.base.vo.CustomermanageVO;

/**
 * 客户管理信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("customermanage")
public class CustomermanageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICustomercontactsService customercontactsService;
    @Autowired
    private ICustomerbankService customerbankService;
    @Autowired
    private IChangeCustomerService changeCustomerService;

    private static final String BILL_CODE = "custom-manage";//此处需要根据实际修改
    private static final String LINKER_BILL_CODE = "custom-lnker";//此处需要根据实际修改
    private static final String BANK_BILL_CODE = "base-bank";//此处需要根据实际修改

    @Autowired
    private ICustomermanageService service;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CustomermanageVO> saveOrUpdate(@RequestBody CustomermanageVO saveOrUpdateVO) {
        CustomermanageEntity entity = BeanMapper.map(saveOrUpdateVO, CustomermanageEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setChangeState("1");
            //        录入联系人时插入客户联系人信息

        }else {
            CommonResponse<ChangeCustomerVO> changvo = this.changvo(entity.getId());
            ChangeCustomerVO data = changvo.getData();
            ChangeCustomerEntity map = BeanMapper.map(data, ChangeCustomerEntity.class);
            changeCustomerService.saveOrUpdate(map,false);
        }
    	// 校验重复性
        QueryWrapper query=new QueryWrapper();
        query.eq("name",entity.getName());
        query.eq("org_id",entity.getOrgId());
        List<CustomermanageEntity> list = service.list(query);
        if (list.size()>0){
            for (int i = 0; i < list.size(); i++) {
                CustomermanageEntity Entity = list.get(i);
                if (!String.valueOf(Entity.getId()).equals(String.valueOf(entity.getId()))){
                    throw new BusinessException("客户名称已存在，请修改客户名称后保存");
                }
            }
        }
        service.saveOrUpdate(entity, false);
    	CustomermanageVO vo = BeanMapper.map(entity, CustomermanageVO.class);
    	if (saveOrUpdateVO.getId()==null){
    	    // 新增时插入客户联系人
            CustomercontactsEntity customercontactsEntity = new CustomercontactsEntity();
            customercontactsEntity.setCustomName(vo.getName());
            customercontactsEntity.setManagearchivesId(vo.getId());
            customercontactsEntity.setPhone(vo.getLinkerPhone());
            customercontactsEntity.setContacts(vo.getLinkerName());
            customercontactsEntity.setOrgId(vo.getOrgId());
            customercontactsEntity.setOrgName(vo.getOrgName());
            CustomercontactsVO map = BeanMapper.map(customercontactsEntity, CustomercontactsVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build(LINKER_BILL_CODE,InvocationInfoProxy.getTenantid(),map);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                customercontactsEntity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 客户联系人编码生成失败， 请稍后再试");
            }
            // 新增时插入客户银行
            customercontactsService.saveOrUpdate(customercontactsEntity,false);
            CustomerbankEntity customerbankEntity = new CustomerbankEntity();
            customerbankEntity.setCustomName(vo.getName());
            customerbankEntity.setManagearchivesId(vo.getId());
            customerbankEntity.setBankCode(vo.getBankAccount());
            customerbankEntity.setBankName(vo.getBankName());
            customerbankEntity.setOrgId(vo.getOrgId());
            customerbankEntity.setOrgName(vo.getOrgName());
            CustomerbankVO map1 = BeanMapper.map(customerbankEntity, CustomerbankVO.class);
            BillCodeParam billCodeParam1 = BillCodeParam.build(BANK_BILL_CODE,InvocationInfoProxy.getTenantid(),map1);
            CommonResponse<String> billCode1 = billCodeApi.generateBillCode(billCodeParam1);
            if(billCode.isSuccess()) {
                customerbankEntity.setCode(billCode1.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 客户银行编码生成失败， 请稍后再试");
            }
            customerbankService.saveOrUpdate(customerbankEntity,false);
        }

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CustomermanageVO> queryDetail(Long id) {
    	CustomermanageEntity entity = service.selectById(id);
    	CustomermanageVO vo = BeanMapper.map(entity, CustomermanageVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CustomermanageVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CustomermanageVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /*CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CustomermanageVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CustomermanageVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CustomermanageEntity> page = service.queryPage(param,false);
        IPage<CustomermanageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomermanageVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CustomermanageEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Customermanage-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCustomermanageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CustomermanageVO>> refCustomermanageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            String orgId = _con.getString("orgId");
            String categoryId = _con.getString("categoryId");
            if (orgId!=null) {
                param.getParams().put("org_id", new Parameter(QueryParam.EQ, orgId));
            }
            if(categoryId != null){
                param.getParams().put("category_id", new Parameter(QueryParam.EQ, categoryId));
            }
        }

        IPage<CustomermanageEntity> page = service.queryPage(param,false);
        IPage<CustomermanageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomermanageVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /***
     * @Description 查询客户联系人列表
     * @param requestVO
     * @return
     */
    @PostMapping(value = "queryDetailByCustomerId")
    @ResponseBody
    public CommonResponse<IPage<CustomercontactsVO>> queryDetailByCustomerId(@RequestBody RequestVO requestVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(requestVO.getPageSize());
        queryParam.setPageIndex(requestVO.getPageIndex());
        queryParam.setOrderMap(requestVO.getOrderMap());
        queryParam.getParams().put("managearchives_id",new Parameter(QueryParam.EQ,requestVO.getId()));
        IPage<CustomercontactsEntity> page = customercontactsService.queryPage(queryParam, false);
        IPage<CustomercontactsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomercontactsVO.class));
        return CommonResponse.success("查询详情成功！", pageData);
    }
    /***
     * @Description 查询客户联系人列表
     * @param requestVO
     * @return
     */
    @PostMapping(value = "queryBankByCustomerId")
    @ResponseBody
    public CommonResponse<IPage<CustomerbankVO>> queryBankByCustomerId(@RequestBody RequestVO requestVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(requestVO.getPageSize());
        queryParam.setPageIndex(requestVO.getPageIndex());
        queryParam.setOrderMap(requestVO.getOrderMap());
        queryParam.getParams().put("managearchives_id",new Parameter(QueryParam.EQ,requestVO.getId()));
        IPage<CustomerbankEntity> page = customerbankService.queryPage(queryParam, false);
        IPage<CustomerbankVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomerbankVO.class));
        return CommonResponse.success("查询详情成功！", pageData);
    }

    /**
     * 根据客户id获取客户变更记录
     * @param customerId
     * @return
     */
    public CommonResponse<ChangeCustomerVO> changvo(Long customerId) {
        CustomermanageEntity entity = service.selectById(customerId);
        CustomermanageVO map = BeanMapper.map(entity, CustomermanageVO.class);
        ChangeCustomerVO changeCustomerVO = new ChangeCustomerVO();
        changeCustomerVO.setName(map.getName());
        changeCustomerVO.setChangeId(entity.getId());
        changeCustomerVO.setOrgId(entity.getOrgId());
        changeCustomerVO.setOrgName(entity.getOrgName());
        changeCustomerVO.setCategoryId(map.getCategoryId());
        changeCustomerVO.setCategoryName(map.getCategoryName());
        changeCustomerVO.setAddress(map.getAddress());
        changeCustomerVO.setCorporateIdNumber(map.getCorporateIdNumber());
        changeCustomerVO.setCreditLevel(map.getCreditLevel());
        changeCustomerVO.setLegalPerson(map.getLegalPerson());
        changeCustomerVO.setCorporatePhone(map.getCorporatePhone());
        changeCustomerVO.setOrgCertificateCode(map.getOrgCertificateCode());
        changeCustomerVO.setLicenseCode(map.getLicenseCode());
        changeCustomerVO.setAbbname(map.getAbbname());
        changeCustomerVO.setRegisteredCapital(map.getRegisteredCapital());
        return CommonResponse.success("查询数据成功！",changeCustomerVO);
    }

}
