package com.ejianc.business.base.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.vo.MaterialVO;
import com.ejianc.business.base.bases.vo.SettlementPerioddetailVO;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.business.base.bases.vo.ShippersfareVO;
import com.ejianc.business.base.bean.MaterialEntity;
import com.ejianc.business.base.bean.ProductEntity;
import com.ejianc.business.base.bean.SettlementPerioddetailEntity;
import com.ejianc.business.base.bean.ShippersVehicleEntity;
import com.ejianc.business.base.service.*;
import com.ejianc.business.base.vo.ProductVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/base/baseApi")
public class BaseApi {
    @Autowired
    IShippersVehicleService service;

    @Autowired
    IShippersfareService shippersfareService;
    @Autowired
    IMaterialService materialService;
    @Autowired
    IProductService productService;
    @Autowired
    ISettlementPerioddetailService settlementPerioddetailService;
    /**
     * 请求获取生产任务单和运输商，运输商车辆信息
     * @param carCode
     * @return
     */
    @PostMapping(value = "/getshippersinfo")
    public CommonResponse<ShippersInfoApiVO> getShippersInfo(@RequestParam(value = "carCode") String carCode,@RequestParam(value = "orgId") Long orgId){
        ShippersInfoApiVO apiVO = new ShippersInfoApiVO();
        QueryWrapper query=new QueryWrapper();
        query.eq("plate_number",carCode);
        query.eq("org_id",orgId);
        ShippersVehicleEntity entity = service.getOne(query);
        if (entity!=null){
            apiVO.setCarId(entity.getId());
            apiVO.setCarName(entity.getName());
            apiVO.setShipperMId(entity.getShipperMId());
            apiVO.setShipperMName(entity.getShipperMName());
            apiVO.setCategory(entity.getCategory());
            apiVO.setTare(entity.getTare());
            QueryWrapper queryfare=new QueryWrapper();
            queryfare.eq("mid",entity.getShipperMId());
            List<ShippersfareVO> list = shippersfareService.list(queryfare);
            apiVO.setShippersfareVOS(list);
        }else {
            throw new BusinessException("车牌号未查到运输商车辆信息");
        }

        return CommonResponse.success("访问成功！！",apiVO);
    }
    /**
     * 请求获取生产任务单和运输商，运输商车辆信息
     * @param
     * @return
     */
    @GetMapping(value = "/updatestatus")
    public CommonResponse updatestatus(@RequestParam(value = "vehicleId") Long vehicleId,@RequestParam(value = "status") Integer status){
        ShippersVehicleEntity entity = service.selectById(vehicleId);
        if (entity!=null){
            entity.setStatus(status);
            service.saveOrUpdate(entity,false);
        }else{
            return CommonResponse.error("未查找到此车辆");
        }
        return CommonResponse.success("车辆状态更新成功！！");
    }
    /**
     * 获取原材料详情
     * @param
     * @return
     */
    @GetMapping(value = "/querymaterialdetail")
    public CommonResponse<com.ejianc.business.base.bases.vo.MaterialVO> querymaterialdetail(Long id){
        MaterialEntity materialEntity = materialService.selectById(id);
        if (materialEntity!=null) {
            MaterialVO materialVO = BeanMapper.map(materialEntity, MaterialVO.class);
            return CommonResponse.success("查询原材料详情成功！！", materialVO);
        }else {
            throw new BusinessException("未查找到原材料信息");
        }
    }
    /**
     * 获取产品详情
     * @param
     * @return
     */
    @GetMapping(value = "/queryproductdetail")
    public CommonResponse<com.ejianc.business.base.bases.vo.ProductVO> queryproductdetail(Long id){
        ProductEntity productEntity = productService.selectById(id);
        if (productEntity!=null) {
            com.ejianc.business.base.bases.vo.ProductVO productVO = BeanMapper.map(productEntity, com.ejianc.business.base.bases.vo.ProductVO.class);
            return CommonResponse.success("查询产品详情成功！！", productVO);
        }else {
            throw new BusinessException("未查找到产品信息");
        }
    }
    /**
     * 获取结算日期
     * @param
     * @return
     */
    @GetMapping(value = "/querysettlement")
    public CommonResponse<SettlementPerioddetailVO> querysettlement(String month){
        QueryWrapper queryfare=new QueryWrapper();
        queryfare.eq("month",month);
        SettlementPerioddetailEntity one = settlementPerioddetailService.getOne(queryfare);
        if (one!=null){
            SettlementPerioddetailVO map = BeanMapper.map(one, SettlementPerioddetailVO.class);
            return CommonResponse.success("查询结算期间成功",map);
        }else {
            throw new BusinessException("未查询到结算期间");
        }
    }

}
