package com.ejianc.business.base.excel;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.ProductSpecEntity;
import com.ejianc.business.base.service.IProductSpecService;
import com.ejianc.business.base.vo.ProductSpecVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;

@Controller
@RequestMapping("productSpecExport")
public class ExcelProductSpecController implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IProductSpecService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "product-spec";//此处需要根据实际修改
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadProductSpec")
    @ResponseBody
    public void downloadMaterialSpec(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "productspec-import.xlsx", "原材料规格导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportProductCate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ProductSpecVO> successList = new ArrayList<>();
        List<ProductSpecVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    ProductSpecVO VO = new ProductSpecVO();
                    VO.setId(IdWorker.getId());
                    VO.setName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'产品规格名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(0));
                        ProductSpecEntity entity = service.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setErrorMsg("查重校验:'产品规格名称'已存在，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    successList.add(VO);
                }
                if (errorList.size()==0) {
                    List<ProductSpecEntity> productSpecEntities = BeanMapper.mapList(successList, ProductSpecEntity.class);
                    for (ProductSpecEntity entity : productSpecEntities) {
                        ProductSpecVO VO = BeanMapper.map(entity, ProductSpecVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(productSpecEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
