package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.ShippersEntity;
import com.ejianc.business.base.bean.ShippersVehicleEntity;
import com.ejianc.business.base.service.IShippersService;
import com.ejianc.business.base.service.IShippersVehicleService;
import com.ejianc.business.base.vo.ShippersVehicleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * 运输商车辆导入
 */
@Controller
@RequestMapping("shippersVehicleExport")
public class ExcelShippersVehicleController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IShippersVehicleService service;
    @Autowired
    private IShippersService shippersService;
    @Autowired
    private IBillCodeApi billCodeApi;


    private static final String BILL_CODE = "shippers-vehicle";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /********************限额设计指标分析清单表导入导出start**************/
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadShippersVehicle")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "shippersvehicle-import.xlsx", "运输商车辆导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportShippersVehicle", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ShippersVehicleVO> successList = new ArrayList<>();
        List<ShippersVehicleVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    Long orgId = InvocationInfoProxy.getOrgId();
                    List<String> data = result.get(i);
                    ShippersVehicleVO VO = new ShippersVehicleVO();
                    VO.setId(IdWorker.getId());
                    VO.setName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setShipperMName(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setPlateNumber(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setGreenPlate(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
                    VO.setTare(StringUtils.isNotBlank(data.get(4)) ? new BigDecimal(data.get(4)) : null);
                    VO.setTonnage(StringUtils.isNotBlank(data.get(5)) ? new BigDecimal(data.get(5)) : null);
                    VO.setVehicleExplain(StringUtils.isNotBlank(data.get(6)) ?data.get(6) : null);
                    VO.setDriver(StringUtils.isNotBlank(data.get(7)) ? data.get(7) : null);
                    VO.setDriverPhone(StringUtils.isNotBlank(data.get(8)) ? data.get(8) : null);
                    VO.setDriverWx(StringUtils.isNotBlank(data.get(9)) ? data.get(9) : null);

                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    VO.setStatus(1);
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'运输商车辆名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }
                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
                        VO.setErrorMsg("'运输商名称'不能为空");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(1));
                        query.eq("org_id",orgId);
                        ShippersEntity entity = shippersService.getOne(query);
                        if (entity!=null){
                            VO.setShipperMId(entity.getId());
                        }else {
                            VO.setErrorMsg("运输商库未查找到运输商名称，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
                        VO.setErrorMsg("'车牌号'不能为空");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("plate_number",data.get(2));
                        query.eq("org_id",orgId);
                        ShippersVehicleEntity entity = service.getOne(query);
                        if (entity!=null){
                            VO.setErrorMsg("查重校验:'车牌号'已存在,请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(3)) || data.get(3) == null) {
                        VO.setErrorMsg("'是否绿牌'不能为空");
                        errorList.add(VO);
                        continue;
                    }else{
                        if ("是".equals(data.get(3))){
                            VO.setGreenPlate("0");
                        }else if ("否".equals(data.get(3))){
                            VO.setGreenPlate("1");
                        }else{
                            VO.setErrorMsg("'是否绿牌'只能为'是'或者'否'");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(4)) || data.get(4) == null) {
                        VO.setErrorMsg("'皮重'不能为空");
                        errorList.add(VO);
                        continue;
                    }
                    if (StringUtils.isEmpty(data.get(7)) || data.get(7) == null) {
                        VO.setErrorMsg("'司机姓名'不能为空");
                        errorList.add(VO);
                        continue;
                    }
                    if (StringUtils.isEmpty(data.get(7)) || data.get(7) == null) {
                        VO.setErrorMsg("'司机手机'不能为空");
                        errorList.add(VO);
                        continue;
                    }
                    successList.add(VO);
                }
                if (errorList.size()==0) {
                    List<ShippersVehicleEntity> shippersVehicleEntities = BeanMapper.mapList(successList, ShippersVehicleEntity.class);
                    for (ShippersVehicleEntity entity : shippersVehicleEntities) {
                        ShippersVehicleVO VO = BeanMapper.map(entity, ShippersVehicleVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(shippersVehicleEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
