package com.ejianc.business.base.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.base.vo.WaagdetailVO;

/**
 * 磅房信息
 * 
 * @author generator
 * 
 */
public class WaagVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 磅房编码
    private String name; // 磅房名称
    private String address; // 磅房位置
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    
    private List<WaagdetailVO> waagdetailList = new ArrayList<>(); // 磅房信息子表

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<WaagdetailVO> getWaagdetailList() {
        return waagdetailList;
     }

     public void setWaagdetailList(List<WaagdetailVO> waagdetailList) {
        this.waagdetailList = waagdetailList;
     }
}
