package com.ejianc.business.base.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.vo.*;
import com.ejianc.business.base.bean.*;
import com.ejianc.business.base.service.*;
import com.ejianc.business.base.vo.ProductVO;
import com.ejianc.business.base.vo.UnitVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;

@RestController
@RequestMapping("/api/base/baseApi")
public class BaseApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IShippersVehicleService service;

    @Autowired
    IShippersfareService shippersfareService;
    @Autowired
    IMaterialdiscountrateService materiadiscountlService;
    @Autowired
    IMaterialService materialService;
    @Autowired
    IProductService productService;
    @Autowired
    IUnitService unitService;
    @Autowired
    ISettlementPerioddetailService settlementPerioddetailService;
    /**
     * 请求获取生产任务单和运输商，运输商车辆信息
     * @param carCode
     * @return
     */
    @PostMapping(value = "/getshippersinfo")
    public CommonResponse<ShippersInfoApiVO> getShippersInfo(@RequestParam(value = "carCode") String carCode,@RequestParam(value = "orgId") Long orgId){
        ShippersInfoApiVO apiVO = new ShippersInfoApiVO();
        QueryWrapper query=new QueryWrapper();
        query.eq("plate_number",carCode);
        query.eq("org_id",orgId);
        ShippersVehicleEntity entity = service.getOne(query);
        if (entity!=null){
            apiVO.setCarId(entity.getId());
            apiVO.setCarName(entity.getName());
            apiVO.setShipperMId(entity.getShipperMId());
            apiVO.setShipperMName(entity.getShipperMName());
            apiVO.setCategory(entity.getCategory());
            apiVO.setTare(entity.getTare());
            QueryWrapper queryfare=new QueryWrapper();
            queryfare.eq("mid",entity.getShipperMId());
            List<ShippersfareVO> list = shippersfareService.list(queryfare);
            apiVO.setShippersfareVOS(list);
        }else {
            throw new BusinessException("车牌号未查到运输商车辆信息");
        }

        return CommonResponse.success("访问成功！！",apiVO);
    }
    /**
     * 请求获取生产任务单和运输商，运输商车辆信息
     * @param
     * @return
     */
    @GetMapping(value = "/updatestatus")
    public CommonResponse updatestatus(@RequestParam(value = "vehicleId") Long vehicleId,@RequestParam(value = "status") Integer status){

        ShippersVehicleEntity entity = service.selectById(vehicleId);
        if (entity!=null){
            entity.setStatus(status);
            service.updateById(entity);
        }else{
            logger.error("更新车辆状态传参{}",vehicleId);
            throw new BusinessException("未查找到此车辆");
        }
        return CommonResponse.success("车辆状态更新成功！！");
    }
    /**
     * 获取原材料扣率
     * @param
     * @return
     */
    @GetMapping(value = "/querymaterialdetail")
    public CommonResponse<MaterialdiscountrateVO> querymaterialdetail(@RequestParam(value = "supplyId")Long supplyId,@RequestParam(value = "materialId")Long materialId,@RequestParam(value = "orgId")Long orgId){
        MaterialdiscountrateVO materialdiscountrateVO = new MaterialdiscountrateVO();
        QueryWrapper queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("supply_id",supplyId);
        queryWrapper.eq("material_id",materialId);
        queryWrapper.eq("org_id",orgId);
        List<MaterialdiscountrateEntity> list = materiadiscountlService.list(queryWrapper);
        if (!list.isEmpty()){
            MaterialdiscountrateEntity materialdiscountrateEntity = list.get(0);
            materialdiscountrateVO= BeanMapper.map(materialdiscountrateEntity, MaterialdiscountrateVO.class);
        }else {
            QueryWrapper query = new QueryWrapper<>();
            query.eq("material_id",materialId);
            query.eq("org_id",orgId);
            List<MaterialdiscountrateEntity> list1 = materiadiscountlService.list(query);
            if (!list1.isEmpty()){
                MaterialdiscountrateEntity materialdiscountrateEntity = list1.get(0);
                materialdiscountrateVO=BeanMapper.map(materialdiscountrateEntity,MaterialdiscountrateVO.class);
            }else {
                MaterialEntity entity = materialService.selectById(materialId);
                materialdiscountrateVO.setMaterialId(entity.getId());
                materialdiscountrateVO.setMaterialName(entity.getName());
                materialdiscountrateVO.setOrgId(orgId);
                materialdiscountrateVO.setDiscountRate(new BigDecimal("100.00"));
            }
        }
        return CommonResponse.success("查询原材料扣率成功",materialdiscountrateVO);
    }
    /**
     * 获取产品详情
     * @param
     * @return
     */
    @GetMapping(value = "/queryproductdetail")
    public CommonResponse<com.ejianc.business.base.bases.vo.ProductVO> queryproductdetail(Long id){
        ProductEntity productEntity = productService.selectById(id);
        if (productEntity!=null) {
            com.ejianc.business.base.bases.vo.ProductVO productVO = BeanMapper.map(productEntity, com.ejianc.business.base.bases.vo.ProductVO.class);
            return CommonResponse.success("查询产品详情成功！！", productVO);
        }else {
            throw new BusinessException("未查找到产品信息");
        }
    }
    /**
     * 获取结算日期
     * @param
     * @return
     */
    @PostMapping(value = "/querysettlement")
    public CommonResponse<SettlementPerioddetailVO> querysettlement(String month,String orgId){

        QueryWrapper queryfare=new QueryWrapper();
        queryfare.eq("month",month);
        queryfare.eq("org_id",orgId);
        SettlementPerioddetailEntity one = settlementPerioddetailService.getOne(queryfare);
        if (one!=null){
            SettlementPerioddetailVO map = BeanMapper.map(one, SettlementPerioddetailVO.class);
            return CommonResponse.success("查询结算期间成功",map);
        }else {
            throw new BusinessException("未查询到结算期间");
        }
    }
    /**
     * 获取结算日期
     * @param
     * @return
     */
    @PostMapping(value = "/queryunit")
    public List<com.ejianc.business.base.bases.vo.UnitVO> queryUnit(String orgId){
        QueryWrapper queryfare=new QueryWrapper();
        queryfare.eq("org_id",orgId);
        List<UnitEntity> list = unitService.list(queryfare);
        List<com.ejianc.business.base.bases.vo.UnitVO> unitVOS = BeanMapper.mapList(list, com.ejianc.business.base.bases.vo.UnitVO.class);
        return unitVOS;
    }

    /**
     * 获取结算日期
     * @param
     * @return
     */
    @PostMapping(value = "/settlement")
    public CommonResponse<String> settlement(String receiptTime,String orgId){

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = null;
        QueryWrapper queryfare=new QueryWrapper();
        queryfare.lt("start_date",receiptTime);
        queryfare.gt("end_date",receiptTime);
        queryfare.eq("org_id",orgId);
        SettlementPerioddetailEntity one = settlementPerioddetailService.getOne(queryfare);
        if (one!=null){
            SettlementPerioddetailVO map  = BeanMapper.map(one, SettlementPerioddetailVO.class);
            time = sdf.format(map.getEndDate());
        }else {
            throw new BusinessException("未查询到结算期间");
        }
        return CommonResponse.success("查询结算期间成功",time);
    }
}
