package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.CustomerbankEntity;
import com.ejianc.business.base.bean.CustomermanageEntity;
import com.ejianc.business.base.bean.MaterialdiscountrateEntity;
import com.ejianc.business.base.service.ICustomerbankService;
import com.ejianc.business.base.service.ICustomermanageService;
import com.ejianc.business.base.service.IMaterialdiscountrateService;
import com.ejianc.business.base.vo.CustomerbankVO;
import com.ejianc.business.base.vo.MaterialdiscountrateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.util.*;

/**
 * 原材料扣率的导入导出
 */
@Controller
@RequestMapping("materialdiscountrateExcel")
public class ExcelMaterialdiscountrateController implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IMaterialdiscountrateService iMaterialdiscountrateService;
    @Autowired
    private IMaterialdiscountrateService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "discount-rate";//此处需要根据实际修改
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaterialdiscountrate")
    @ResponseBody
    public void downloadCustomerbank(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "materialdiscountrate-import.xlsx", "原材料扣率导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportMaterialdiscountrate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialdiscountrate(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
//        返回导入合法的数据的VO
        List<MaterialdiscountrateVO> successList = new ArrayList<>();
//        返回导入数据不合法的VO
        List<MaterialdiscountrateVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
//        校验导入文件合法性
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
//            读取导入excel文件的数据
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
//                    获取导入数据的每一条数据校验合法性
                    List<String> data = result.get(i);
                    MaterialdiscountrateVO VO = new MaterialdiscountrateVO();
//                    具体逻辑 data.get（index）为获取某个单元格的数据
                    VO.setId(IdWorker.getId());
                    VO.setBillCode(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setMaterialName(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setSupplyName(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
//                    VO.setDiscountRate(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
//                    VO.setCreateTime(StringUtils.isNotBlank(data.get(4)) ? data.get(4) : null);
//                    每一条数据都要设置租户id
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
//                    每一条数据设置组织id
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
//                    每一条数据设置创建人
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
//                    每一条数据设置创建时间
                    VO.setCreateTime(new Date());
//                    校验每一个单元格的合法性 如不能为空 或重复性校验
//                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
////                        如果不合法设置错误信息
//                        VO.setErrorMsg("'客户名称'不能为空！");
////                        添加到不合法信息数据的VO里
//                        errorList.add(VO);
////                        退出本次循环
//                        continue;
//                    }else{
//                        QueryWrapper query=new QueryWrapper();
//                        query.eq("name",data.get(0));
//                        query.eq("org_id",InvocationInfoProxy.getOrgId());
//                        CustomermanageEntity entity = customermanageService.getOne(query);
//                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
//                            VO.setManagearchivesId(entity.getId());
//                        }else {
//                            VO.setErrorMsg("客户名称库未查找到客户名称，请检查！");
//                            errorList.add(VO);
//                            continue;
//                        }
//                    }
//                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
//                        VO.setErrorMsg("'银行名称'不能为空！");
//                        errorList.add(VO);
//                        continue;
//                    }
//                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
//                        VO.setErrorMsg("'银行账号'不能为空！");
//                        errorList.add(VO);
//                        continue;
//                    }else {
//                        QueryWrapper query=new QueryWrapper();
//                        query.eq("bank_code",data.get(2));
//                        query.eq("org_id",InvocationInfoProxy.getOrgId());
//                        CustomerbankEntity entity = service.getOne(query);
//                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
//                            VO.setErrorMsg("查重校验:'银行账号'已存在，请检查！");
//                            errorList.add(VO);
//                            continue;
//                        }
//                    }
//                  如果校验合法 将这条数据放入合法的list里面
                    successList.add(VO);
                }
//                插入保存逻辑 当不合法的数据为空时才插入保存到数据库
                if (errorList.size()==0) {
//                    如果都合法 将所有的合法数据由VO转换为Entity进行批量保存 如果涉及到子表则需要主表和子表分开保存
                    List<MaterialdiscountrateEntity> materialdiscountrateEntities = BeanMapper.mapList(successList, MaterialdiscountrateEntity.class);
//                    循环生产每条导入数据的单据编号
                    for (MaterialdiscountrateEntity entity : materialdiscountrateEntities) {
                        MaterialdiscountrateVO VO = BeanMapper.map(entity, MaterialdiscountrateVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                        if(billCode.isSuccess()) {
//                            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                        }
                    }
                    service.saveBatch(materialdiscountrateEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
