package com.ejianc.business.base.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 原材料扣率
 * 
 * @author generator
 * 
 */
public class MaterialdiscountrateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long materialId; // 原材料id主键
    private String materialName; // 原材料名称
    private Long supplyId; // 供应商id
    private String supplyName; // 供应商名称
    private BigDecimal discountRate; // 扣率
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String billCode; // 单据编号

    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    @ReferSerialTransfer(referCode="MaterialRef")
    public Long getSupplyId() {
        return supplyId;
    }
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public BigDecimal getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
