package com.ejianc.business.base.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 产品
 * 
 * @author generator
 * 
 */
public class ProductVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private String name; // 运输商名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String operatorId; // 经办人id
    private String operatorName; // 经办人名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private Long categoryId; // 产品类别主键
    private Long specId; // 产品规格主键
    private Long gradeId; // 产品级配主键
    private String alias; // 产品别名
    private Integer blocStandard; // 集团标准
    private Long stoneId; // 石料主键
    private Long asphaltId; // 沥青主键
    private Long blocProductId; // 集团产品主键
    private String specName; // 产品规格名称
    private String categoryName; // 产品类别名称
    private String gradeName; // 产品级配名称
    private String stoneName; // 石料名称
    private String asphaltName; // 沥青名称
    private String blocProductName; // 集团产品名称
    private String comprehensiveUtilizationName; // 综合利用别名
    private Integer isDutyFree; // 是否免税
    private BigDecimal taxRate; // 税率
    private BigDecimal suggestedPrice; // 建议价格
    private Integer hideFlag; // 隐藏标志:0 显示 1 不显示
    private Integer isAlways; // 是否常用:0 是 1 否
    private String errorMsg;


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    @ReferSerialTransfer(referCode="ProductCategoryRef")
    public Long getCategoryId() {
        return categoryId;
    }

    @ReferDeserialTransfer
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    @ReferSerialTransfer(referCode="ProductSpecRef")
    public Long getSpecId() {
        return specId;
    }

    @ReferDeserialTransfer
    public void setSpecId(Long specId) {
        this.specId = specId;
    }
    @ReferSerialTransfer(referCode="ProductGradeRef")
    public Long getGradeId() {
        return gradeId;
    }

    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
    public Integer getBlocStandard() {
        return blocStandard;
    }

    public void setBlocStandard(Integer blocStandard) {
        this.blocStandard = blocStandard;
    }
    @ReferSerialTransfer(referCode="MaterialVarietiesRef")
    public Long getStoneId() {
        return stoneId;
    }

    @ReferDeserialTransfer
    public void setStoneId(Long stoneId) {
        this.stoneId = stoneId;
    }
    @ReferSerialTransfer(referCode="MaterialVarietiesRef")
    public Long getAsphaltId() {
        return asphaltId;
    }

    @ReferDeserialTransfer
    public void setAsphaltId(Long asphaltId) {
        this.asphaltId = asphaltId;
    }
    public Long getBlocProductId() {
        return blocProductId;
    }

    public void setBlocProductId(Long blocProductId) {
        this.blocProductId = blocProductId;
    }

    public String getSpecName() {
        return specName;
    }

    public void setSpecName(String specName) {
        this.specName = specName;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getStoneName() {
        return stoneName;
    }

    public void setStoneName(String stoneName) {
        this.stoneName = stoneName;
    }
    public String getAsphaltName() {
        return asphaltName;
    }

    public void setAsphaltName(String asphaltName) {
        this.asphaltName = asphaltName;
    }
    public String getBlocProductName() {
        return blocProductName;
    }

    public void setBlocProductName(String blocProductName) {
        this.blocProductName = blocProductName;
    }

    public String getComprehensiveUtilizationName() {
        return comprehensiveUtilizationName;
    }

    public void setComprehensiveUtilizationName(String comprehensiveUtilizationName) {
        this.comprehensiveUtilizationName = comprehensiveUtilizationName;
    }

    public Integer getIsDutyFree() {
        return isDutyFree;
    }

    public void setIsDutyFree(Integer isDutyFree) {
        this.isDutyFree = isDutyFree;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getSuggestedPrice() {
        return suggestedPrice;
    }

    public void setSuggestedPrice(BigDecimal suggestedPrice) {
        this.suggestedPrice = suggestedPrice;
    }

    public Integer getHideFlag() {
        return hideFlag;
    }

    public void setHideFlag(Integer hideFlag) {
        this.hideFlag = hideFlag;
    }

    public Integer getIsAlways() {
        return isAlways;
    }

    public void setIsAlways(Integer isAlways) {
        this.isAlways = isAlways;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
