/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.base.bean.CustomerbankEntity;
import com.ejianc.business.base.bean.CustomercontactsEntity;
import com.ejianc.business.base.bean.CustomermanageEntity;
import com.ejianc.business.base.service.ICustomerbankService;
import com.ejianc.business.base.service.ICustomercontactsService;
import com.ejianc.business.base.service.ICustomermanageService;
import com.ejianc.business.base.utils.HttpUtils;
import com.ejianc.business.base.vo.CustomerbankVO;
import com.ejianc.business.base.vo.CustomercontactsVO;
import com.ejianc.business.base.vo.CustomermanageVO;
import com.ejianc.business.base.vo.RequestVO;
import com.ejianc.business.change.bean.ChangeCustomerEntity;
import com.ejianc.business.change.service.IChangeCustomerService;
import com.ejianc.business.change.vo.ChangeCustomerVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"customermanage"})
public class CustomermanageController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICustomercontactsService customercontactsService;
    @Autowired
    private ICustomerbankService customerbankService;
    @Autowired
    private IChangeCustomerService changeCustomerService;
    private static final String BILL_CODE = "custom-manage";
    private static final String LINKER_BILL_CODE = "custom-lnker";
    private static final String BANK_BILL_CODE = "base-bank";
    @Autowired
    private ICustomermanageService service;
    @Autowired
    private SessionManager sessionManager;

    @Transactional
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CustomermanageVO> saveOrUpdate(@RequestBody CustomermanageVO saveOrUpdateVO) {
        CustomermanageEntity entity = (CustomermanageEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), CustomermanageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setChangeState("1");
        } else {
            CommonResponse<ChangeCustomerVO> changvo = this.changvo(entity.getId());
            ChangeCustomerVO data = (ChangeCustomerVO)((Object)changvo.getData());
            ChangeCustomerEntity map = (ChangeCustomerEntity)((Object)BeanMapper.map((Object)((Object)data), ChangeCustomerEntity.class));
            this.changeCustomerService.saveOrUpdate((Object)map, false);
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"name", (Object)entity.getName());
        query.eq((Object)"org_id", (Object)entity.getOrgId());
        List list = this.service.list((Wrapper)query);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                CustomermanageEntity Entity = (CustomermanageEntity)((Object)list.get(i));
                if (String.valueOf(Entity.getId()).equals(String.valueOf(entity.getId()))) continue;
                throw new BusinessException("\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5ba2\u6237\u540d\u79f0\u540e\u4fdd\u5b58");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CustomermanageVO vo = (CustomermanageVO)((Object)BeanMapper.map((Object)((Object)entity), CustomermanageVO.class));
        if (saveOrUpdateVO.getId() == null) {
            if (saveOrUpdateVO.getLinkerName() != null) {
                CustomercontactsEntity customercontactsEntity = new CustomercontactsEntity();
                customercontactsEntity.setCustomName(vo.getName());
                customercontactsEntity.setManagearchivesId(vo.getId());
                customercontactsEntity.setPhone(vo.getLinkerPhone());
                customercontactsEntity.setContacts(vo.getLinkerName());
                customercontactsEntity.setOrgId(vo.getOrgId());
                customercontactsEntity.setOrgName(vo.getOrgName());
                CustomercontactsVO map = (CustomercontactsVO)((Object)BeanMapper.map((Object)((Object)customercontactsEntity), CustomercontactsVO.class));
                BillCodeParam billCodeParam = BillCodeParam.build((String)LINKER_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)map);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u5ba2\u6237\u8054\u7cfb\u4eba\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                customercontactsEntity.setCode((String)billCode.getData());
                this.customercontactsService.saveOrUpdate((Object)customercontactsEntity, false);
            }
            if (saveOrUpdateVO.getBankName() != null) {
                CustomerbankEntity customerbankEntity = new CustomerbankEntity();
                customerbankEntity.setCustomName(vo.getName());
                customerbankEntity.setManagearchivesId(vo.getId());
                customerbankEntity.setBankCode(vo.getBankAccount());
                customerbankEntity.setBankName(vo.getBankName());
                customerbankEntity.setOrgId(vo.getOrgId());
                customerbankEntity.setOrgName(vo.getOrgName());
                CustomerbankVO map1 = (CustomerbankVO)((Object)BeanMapper.map((Object)((Object)customerbankEntity), CustomerbankVO.class));
                BillCodeParam billCodeParam1 = BillCodeParam.build((String)BANK_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)map1);
                CommonResponse billCode1 = this.billCodeApi.generateBillCode(billCodeParam1);
                if (!billCode1.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u5ba2\u6237\u94f6\u884c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                customerbankEntity.setCode((String)billCode1.getData());
                this.customerbankService.saveOrUpdate((Object)customerbankEntity, false);
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CustomermanageVO> queryDetail(Long id) {
        CustomermanageEntity entity = (CustomermanageEntity)((Object)this.service.selectById(id));
        CustomermanageVO vo = (CustomermanageVO)((Object)BeanMapper.map((Object)((Object)entity), CustomermanageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CustomermanageVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CustomermanageVO customermanageVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CustomermanageVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomermanageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Customermanage-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCustomermanageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CustomermanageVO>> refCustomermanageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            String orgId = _con.getString("orgId");
            String categoryId = _con.getString("categoryId");
            String isHelp = _con.getString("isHelp");
            if (orgId != null) {
                param.getParams().put("org_id", new Parameter("eq", (Object)orgId));
            }
            if (categoryId != null) {
                param.getParams().put("category_id", new Parameter("eq", (Object)categoryId));
            }
            if (isHelp != null) {
                param.getParams().put("is_help", new Parameter("eq", (Object)isHelp));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomermanageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"queryDetailByCustomerId"})
    @ResponseBody
    public CommonResponse<IPage<CustomercontactsVO>> queryDetailByCustomerId(@RequestBody RequestVO requestVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(requestVO.getPageSize());
        queryParam.setPageIndex(requestVO.getPageIndex());
        queryParam.setOrderMap(requestVO.getOrderMap());
        queryParam.getParams().put("managearchives_id", new Parameter("eq", (Object)requestVO.getId()));
        IPage page = this.customercontactsService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomercontactsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"queryBankByCustomerId"})
    @ResponseBody
    public CommonResponse<IPage<CustomerbankVO>> queryBankByCustomerId(@RequestBody RequestVO requestVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(requestVO.getPageSize());
        queryParam.setPageIndex(requestVO.getPageIndex());
        queryParam.setOrderMap(requestVO.getOrderMap());
        queryParam.getParams().put("managearchives_id", new Parameter("eq", (Object)requestVO.getId()));
        IPage page = this.customerbankService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomerbankVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", (Object)pageData);
    }

    public CommonResponse<ChangeCustomerVO> changvo(Long customerId) {
        CustomermanageEntity entity = (CustomermanageEntity)((Object)this.service.selectById(customerId));
        CustomermanageVO map = (CustomermanageVO)((Object)BeanMapper.map((Object)((Object)entity), CustomermanageVO.class));
        ChangeCustomerVO changeCustomerVO = new ChangeCustomerVO();
        changeCustomerVO.setName(map.getName());
        changeCustomerVO.setChangeId(entity.getId());
        changeCustomerVO.setOrgId(entity.getOrgId());
        changeCustomerVO.setOrgName(entity.getOrgName());
        changeCustomerVO.setCategoryId(map.getCategoryId());
        changeCustomerVO.setCategoryName(map.getCategoryName());
        changeCustomerVO.setAddress(map.getAddress());
        changeCustomerVO.setCorporateIdNumber(map.getCorporateIdNumber());
        changeCustomerVO.setCreditLevel(map.getCreditLevel());
        changeCustomerVO.setLegalPerson(map.getLegalPerson());
        changeCustomerVO.setCorporatePhone(map.getCorporatePhone());
        changeCustomerVO.setOrgCertificateCode(map.getOrgCertificateCode());
        changeCustomerVO.setLicenseCode(map.getLicenseCode());
        changeCustomerVO.setAbbname(map.getAbbname());
        changeCustomerVO.setRegisteredCapital(map.getRegisteredCapital());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)((Object)changeCustomerVO));
    }

    @RequestMapping(value={"/tianyancharequest"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changvo(String customerName) {
        String tianyanchaUrl = "http://open.api.tianyancha.com/services/open/ic/baseinfoV2/2.0?name=" + customerName;
        String token = "9da91dae-1ac1-48f6-8f00-154af2e30546";
        String result = HttpUtils.executeGet(tianyanchaUrl, token);
        return CommonResponse.success((String)"\u67e5\u8be2\u5929\u773c\u67e5\u6210\u529f", (Object)result);
    }
}

