/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.MaterialEntity;
import com.ejianc.business.base.bean.MaterialdiscountrateEntity;
import com.ejianc.business.base.service.IMaterialService;
import com.ejianc.business.base.service.IMaterialdiscountrateService;
import com.ejianc.business.base.vo.MaterialdiscountrateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialdiscountrateExcel"})
public class ExcelMaterialdiscountrateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IMaterialService iMaterialService;
    @Autowired
    private IMaterialdiscountrateService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "discount-rate";

    @RequestMapping(value={"/downloadMaterialdiscountrate"})
    @ResponseBody
    public void downloadMaterialdiscountrate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"materialdiscountrate-import.xlsx", (String)"\u539f\u6750\u6599\u6263\u7387\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaterialdiscountrate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialdiscountrate(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialdiscountrateVO> successList = new ArrayList<MaterialdiscountrateVO>();
        ArrayList<MaterialdiscountrateVO> errorList = new ArrayList<MaterialdiscountrateVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                MaterialdiscountrateVO VO = new MaterialdiscountrateVO();
                VO.setId(IdWorker.getId());
                VO.setMaterialName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setSupplyName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? (String)data.get(1) : null);
                VO.setDiscountRate(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? new BigDecimal((String)data.get(2)) : null);
                VO.setCreateTime(new Date());
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u539f\u6750\u6599\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"name", data.get(0));
                MaterialEntity entity = (MaterialEntity)((Object)this.iMaterialService.getOne((Wrapper)query));
                if (entity == null || entity.getId() == null && entity.getId() == 0L) {
                    VO.setErrorMsg("\u539f\u6750\u6599\u540d\u79f0\u5e93\u672a\u67e5\u627e\u5230\u539f\u6750\u6599\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                VO.setMaterialId(entity.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u539f\u6750\u6599\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u4f9b\u5e94\u5546\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(2))) || data.get(2) == null) {
                    VO.setErrorMsg("'\u6263\u7387\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List materialdiscountrateEntities = BeanMapper.mapList(successList, MaterialdiscountrateEntity.class);
                for (MaterialdiscountrateEntity entity : materialdiscountrateEntities) {
                    MaterialdiscountrateVO VO = (MaterialdiscountrateVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialdiscountrateVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveBatch(materialdiscountrateEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

