/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.ShippersBankEntity;
import com.ejianc.business.base.bean.ShippersEntity;
import com.ejianc.business.base.service.IShippersBankService;
import com.ejianc.business.base.service.IShippersService;
import com.ejianc.business.base.vo.ShippersBankVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"shipperBankExport"})
public class ExcelShipperBankController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IShippersBankService service;
    @Autowired
    private IShippersService shippersService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "shippers-bank";

    @RequestMapping(value={"/downloadShipperbank"})
    @ResponseBody
    public void downloadSupplybank(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"shipperbank-import.xlsx", (String)"\u8fd0\u8f93\u5546\u94f6\u884c\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportShipperbank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportSupplybank(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ShippersBankVO> successList = new ArrayList<ShippersBankVO>();
        ArrayList<ShippersBankVO> errorList = new ArrayList<ShippersBankVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                ShippersBankVO VO = new ShippersBankVO();
                VO.setId(IdWorker.getId());
                VO.setName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setShipperManageName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? (String)data.get(1) : null);
                VO.setBankName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? (String)data.get(2) : null);
                VO.setBankAccount(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setBankCode(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? (String)data.get(4) : null);
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u8fd0\u8f93\u5546\u94f6\u884c\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u8fd0\u8f93\u5546\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"supply_name", data.get(1));
                query.eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId());
                BaseEntity entity = (ShippersEntity)((Object)this.shippersService.getOne((Wrapper)query));
                if (entity == null || entity.getId() == null && entity.getId() == 0L) {
                    VO.setErrorMsg("\u8fd0\u8f93\u5546\u540d\u79f0\u5e93\u672a\u67e5\u627e\u5230\u8fd0\u8f93\u5546\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                VO.setShipperMid(entity.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(2))) || data.get(2) == null) {
                    VO.setErrorMsg("'\u94f6\u884c\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(3))) || data.get(3) == null) {
                    VO.setErrorMsg("'\u94f6\u884c\u6237\u540d'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(4))) || data.get(4) == null) {
                    VO.setErrorMsg("'\u94f6\u884c\u8d26\u53f7'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"bank_account", data.get(4));
                query.eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId());
                entity = (ShippersBankEntity)((Object)this.service.getOne((Wrapper)query));
                if (entity != null && (entity.getId() != null || entity.getId() != 0L)) {
                    VO.setErrorMsg("\u67e5\u91cd\u6821\u9a8c:'\u94f6\u884c\u8d26\u53f7'\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List shippersBankEntities = BeanMapper.mapList(successList, ShippersBankEntity.class);
                for (ShippersBankEntity entity : shippersBankEntities) {
                    ShippersBankVO VO = (ShippersBankVO)((Object)BeanMapper.map((Object)((Object)entity), ShippersBankVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveBatch(shippersBankEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

