/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.VarietiesaccountingEntity;
import com.ejianc.business.base.service.IVarietiesaccountingService;
import com.ejianc.business.base.vo.SupplierlinkerVO;
import com.ejianc.business.base.vo.VarietiesaccountingVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"varietiesaccountingExcel"})
public class ExcelVarietiesaccountingController {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IVarietiesaccountingService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "supply-lnker";

    @RequestMapping(value={"/downloadVarietiesaccounting"})
    @ResponseBody
    public void downloadCustomerlinker(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"varietiesaccounting-import.xlsx", (String)"\u6838\u7b97\u54c1\u79cd\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportVarietiesaccounting"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportCustomerlinker(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<VarietiesaccountingVO> successList = new ArrayList<VarietiesaccountingVO>();
        ArrayList<VarietiesaccountingVO> errorList = new ArrayList<VarietiesaccountingVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                VarietiesaccountingVO VO = new VarietiesaccountingVO();
                VO.setId(IdWorker.getId());
                VO.setName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u6838\u7b97\u54c1\u79cd'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"name", data.get(0));
                VarietiesaccountingEntity entity = (VarietiesaccountingEntity)((Object)this.service.getOne((Wrapper)query));
                if (entity != null && (entity.getId() != null || entity.getId() != 0L)) {
                    VO.setErrorMsg("\u540d\u79f0\u91cd\u590d\uff01");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List varietiesaccountingEntities = BeanMapper.mapList(successList, VarietiesaccountingEntity.class);
                for (VarietiesaccountingEntity entity : varietiesaccountingEntities) {
                    SupplierlinkerVO VO = (SupplierlinkerVO)((Object)BeanMapper.map((Object)((Object)entity), SupplierlinkerVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveBatch(varietiesaccountingEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

