/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.vo.MaterialdiscountrateVO;
import com.ejianc.business.base.bases.vo.ProductVO;
import com.ejianc.business.base.bases.vo.SettlementPerioddetailVO;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.business.base.bases.vo.UnitVO;
import com.ejianc.business.base.bean.MaterialEntity;
import com.ejianc.business.base.bean.MaterialdiscountrateEntity;
import com.ejianc.business.base.bean.ProductEntity;
import com.ejianc.business.base.bean.SettlementPerioddetailEntity;
import com.ejianc.business.base.bean.ShippersVehicleEntity;
import com.ejianc.business.base.service.IMaterialService;
import com.ejianc.business.base.service.IMaterialdiscountrateService;
import com.ejianc.business.base.service.IProductService;
import com.ejianc.business.base.service.ISettlementPerioddetailService;
import com.ejianc.business.base.service.IShippersVehicleService;
import com.ejianc.business.base.service.IShippersfareService;
import com.ejianc.business.base.service.IUnitService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/base/baseApi"})
public class BaseApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IShippersVehicleService service;
    @Autowired
    IShippersfareService shippersfareService;
    @Autowired
    IMaterialdiscountrateService materiadiscountlService;
    @Autowired
    IMaterialService materialService;
    @Autowired
    IProductService productService;
    @Autowired
    IUnitService unitService;
    @Autowired
    ISettlementPerioddetailService settlementPerioddetailService;

    @PostMapping(value={"/getshippersinfo"})
    public CommonResponse<ShippersInfoApiVO> getShippersInfo(@RequestParam(value="carCode") String carCode, @RequestParam(value="orgId") Long orgId) {
        ShippersInfoApiVO apiVO = new ShippersInfoApiVO();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"plate_number", (Object)carCode);
        query.eq((Object)"org_id", (Object)orgId);
        ShippersVehicleEntity entity = (ShippersVehicleEntity)((Object)this.service.getOne((Wrapper)query));
        if (entity == null) {
            throw new BusinessException("\u8f66\u724c\u53f7\u672a\u67e5\u5230\u8fd0\u8f93\u5546\u8f66\u8f86\u4fe1\u606f");
        }
        apiVO.setCarId(entity.getId());
        apiVO.setCarName(entity.getName());
        apiVO.setShipperMId(entity.getShipperMId());
        apiVO.setShipperMName(entity.getShipperMName());
        apiVO.setCategory(entity.getCategory());
        apiVO.setTare(entity.getTare());
        QueryWrapper queryfare = new QueryWrapper();
        queryfare.eq((Object)"mid", (Object)entity.getShipperMId());
        List list = this.shippersfareService.list((Wrapper)queryfare);
        apiVO.setShippersfareVOS(list);
        return CommonResponse.success((String)"\u8bbf\u95ee\u6210\u529f\uff01\uff01", (Object)apiVO);
    }

    @GetMapping(value={"/updatestatus"})
    public CommonResponse updatestatus(@RequestParam(value="vehicleId") Long vehicleId, @RequestParam(value="status") Integer status) {
        ShippersVehicleEntity entity = (ShippersVehicleEntity)((Object)this.service.selectById(vehicleId));
        if (entity == null) {
            this.logger.error("\u66f4\u65b0\u8f66\u8f86\u72b6\u6001\u4f20\u53c2{}", (Object)vehicleId);
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u6b64\u8f66\u8f86");
        }
        entity.setStatus(status);
        this.service.updateById((Object)entity);
        return CommonResponse.success((String)"\u8f66\u8f86\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01\uff01");
    }

    @GetMapping(value={"/querymaterialdetail"})
    public CommonResponse<MaterialdiscountrateVO> querymaterialdetail(@RequestParam(value="supplyId") Long supplyId, @RequestParam(value="materialId") Long materialId, @RequestParam(value="orgId") Long orgId) {
        MaterialdiscountrateVO materialdiscountrateVO = new MaterialdiscountrateVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supply_id", (Object)supplyId);
        queryWrapper.eq((Object)"material_id", (Object)materialId);
        queryWrapper.eq((Object)"org_id", (Object)orgId);
        List list = this.materiadiscountlService.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            MaterialdiscountrateEntity materialdiscountrateEntity = (MaterialdiscountrateEntity)((Object)list.get(0));
            materialdiscountrateVO = (MaterialdiscountrateVO)BeanMapper.map((Object)((Object)materialdiscountrateEntity), MaterialdiscountrateVO.class);
        } else {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"material_id", (Object)materialId);
            query.eq((Object)"org_id", (Object)orgId);
            query.isNull((Object)"supply_id");
            List list1 = this.materiadiscountlService.list((Wrapper)query);
            if (!list1.isEmpty()) {
                MaterialdiscountrateEntity materialdiscountrateEntity = (MaterialdiscountrateEntity)((Object)list1.get(0));
                materialdiscountrateVO = (MaterialdiscountrateVO)BeanMapper.map((Object)((Object)materialdiscountrateEntity), MaterialdiscountrateVO.class);
            } else {
                MaterialEntity entity = (MaterialEntity)((Object)this.materialService.selectById(materialId));
                materialdiscountrateVO.setMaterialId(entity.getId());
                materialdiscountrateVO.setMaterialName(entity.getName());
                materialdiscountrateVO.setOrgId(orgId);
                materialdiscountrateVO.setDiscountRate(entity.getDiscountRateId() == null ? new BigDecimal("100") : entity.getDiscountRateId());
                materialdiscountrateVO.setSpecName(entity.getSpecName());
                materialdiscountrateVO.setDecimalPoint(entity.getDecimalPlacesId());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u539f\u6750\u6599\u6263\u7387\u6210\u529f", (Object)materialdiscountrateVO);
    }

    @GetMapping(value={"/queryproductdetail"})
    public CommonResponse<ProductVO> queryproductdetail(Long id) {
        ProductEntity productEntity = (ProductEntity)((Object)this.productService.selectById(id));
        if (productEntity != null) {
            ProductVO productVO = (ProductVO)BeanMapper.map((Object)((Object)productEntity), ProductVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u4ea7\u54c1\u8be6\u60c5\u6210\u529f\uff01\uff01", (Object)productVO);
        }
        throw new BusinessException("\u672a\u67e5\u627e\u5230\u4ea7\u54c1\u4fe1\u606f");
    }

    @PostMapping(value={"/querysettlement"})
    public CommonResponse<SettlementPerioddetailVO> querysettlement(String month, String orgId) {
        QueryWrapper queryfare = new QueryWrapper();
        queryfare.eq((Object)"month", (Object)month);
        queryfare.eq((Object)"org_id", (Object)orgId);
        SettlementPerioddetailEntity one = (SettlementPerioddetailEntity)((Object)this.settlementPerioddetailService.getOne((Wrapper)queryfare));
        if (one != null) {
            SettlementPerioddetailVO map = (SettlementPerioddetailVO)BeanMapper.map((Object)((Object)one), SettlementPerioddetailVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u7ed3\u7b97\u671f\u95f4\u6210\u529f", (Object)map);
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u671f\u95f4");
    }

    @PostMapping(value={"/queryunit"})
    public List<UnitVO> queryUnit(String orgId) {
        QueryWrapper queryfare = new QueryWrapper();
        queryfare.eq((Object)"org_id", (Object)orgId);
        List list = this.unitService.list((Wrapper)queryfare);
        List unitVOS = BeanMapper.mapList((Iterable)list, UnitVO.class);
        return unitVOS;
    }

    @PostMapping(value={"/settlement"})
    public CommonResponse<String> settlement(String receiptTime, String orgId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = null;
        QueryWrapper queryfare = new QueryWrapper();
        queryfare.lt((Object)"start_date", (Object)receiptTime);
        queryfare.gt((Object)"end_date", (Object)receiptTime);
        queryfare.eq((Object)"org_id", (Object)orgId);
        SettlementPerioddetailEntity one = (SettlementPerioddetailEntity)((Object)this.settlementPerioddetailService.getOne((Wrapper)queryfare));
        if (one == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u671f\u95f4");
        }
        SettlementPerioddetailVO map = (SettlementPerioddetailVO)BeanMapper.map((Object)((Object)one), SettlementPerioddetailVO.class);
        time = sdf.format(map.getEndDate());
        return CommonResponse.success((String)"\u67e5\u8be2\u7ed3\u7b97\u671f\u95f4\u6210\u529f", (Object)time);
    }
}

