/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.MaterialCategoryEntity;
import com.ejianc.business.base.bean.MaterialEntity;
import com.ejianc.business.base.bean.MaterialSpecEntity;
import com.ejianc.business.base.bean.MaterialVarietiesEntity;
import com.ejianc.business.base.service.IMaterialCategoryService;
import com.ejianc.business.base.service.IMaterialService;
import com.ejianc.business.base.service.IMaterialSpecService;
import com.ejianc.business.base.service.IMaterialVarietiesService;
import com.ejianc.business.base.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialExport"})
public class ExcelMaterialController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IMaterialVarietiesService materialVarietiesService;
    @Autowired
    private IMaterialSpecService materialSpecService;
    @Autowired
    private IMaterialService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "base-material";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/downloadMaterial"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u539f\u6750\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaterial"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialVO> successList = new ArrayList<MaterialVO>();
        ArrayList<MaterialVO> errorList = new ArrayList<MaterialVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                MaterialVO VO = new MaterialVO();
                VO.setId(IdWorker.getId());
                VO.setCategoryName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setVarietiesName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? (String)data.get(1) : null);
                VO.setSpecName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? (String)data.get(2) : null);
                VO.setName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setTaxAttributesId(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? (String)data.get(4) : null);
                VO.setInspectionModeId(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(5))) ? (String)data.get(5) : null);
                VO.setDiscountRateId(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(6))) ? new BigDecimal((String)data.get(6)) : null);
                VO.setDecimalPlacesId(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(7))) ? (String)data.get(7) : null);
                VO.setReferencePrice(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(8))) ? new BigDecimal((String)data.get(8)) : null);
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u6750\u6599\u7c7b\u522b'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"name", data.get(0));
                BaseEntity entity = (MaterialCategoryEntity)((Object)this.materialCategoryService.getOne((Wrapper)query));
                if (entity == null || entity.getId() == null && entity.getId() == 0L) {
                    VO.setErrorMsg("\u6750\u6599\u7c7b\u522b\u5e93\u672a\u67e5\u627e\u5230\u6b64\u6750\u6599\u7c7b\u522b\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                VO.setCategoryId(entity.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u6750\u6599\u54c1\u79cd'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(1));
                entity = (MaterialVarietiesEntity)((Object)this.materialVarietiesService.getOne((Wrapper)query));
                if (entity == null || entity.getId() == null && entity.getId() == 0L) {
                    VO.setErrorMsg("\u6750\u6599\u54c1\u79cd\u5e93\u672a\u67e5\u627e\u5230\u6b64\u6750\u6599\u54c1\u79cd\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                VO.setVarietiesId(entity.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(2))) || data.get(2) == null) {
                    VO.setErrorMsg("'\u6750\u6599\u89c4\u683c'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(2));
                entity = (MaterialSpecEntity)((Object)this.materialSpecService.getOne((Wrapper)query));
                if (entity == null || entity.getId() == null && entity.getId() == 0L) {
                    VO.setErrorMsg("\u6750\u6599\u89c4\u683c\u5e93\u672a\u67e5\u627e\u5230\u6b64\u6750\u6599\u89c4\u683c\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                VO.setSpecId(entity.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(3))) || data.get(3) == null) {
                    VO.setErrorMsg("'\u539f\u6750\u6599\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(3));
                query.eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId());
                entity = (MaterialEntity)((Object)this.service.getOne((Wrapper)query));
                if (entity != null && (entity.getId() != null || entity.getId() != 0L)) {
                    VO.setErrorMsg("\u67e5\u91cd\u6821\u9a8c:'\u539f\u6750\u6599\u540d\u79f0'\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List materialEntities = BeanMapper.mapList(successList, MaterialEntity.class);
                for (MaterialEntity entity : materialEntities) {
                    MaterialVO VO = (MaterialVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveBatch(materialEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

