/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.ShippersEntity;
import com.ejianc.business.base.bean.ShippersfareEntity;
import com.ejianc.business.base.service.IShippersService;
import com.ejianc.business.base.service.IShippersfareService;
import com.ejianc.business.base.vo.ShippersVO;
import com.ejianc.business.base.vo.ShippersfareVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"shippersExport"})
public class ExcelShippersController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IShippersService service;
    @Autowired
    private IShippersfareService shippersfareService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "base-shippers";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/downloadShippers"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"shippers-import.xlsx", (String)"\u8fd0\u8f93\u5546\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportShippers"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ShippersVO> successList = new ArrayList<ShippersVO>();
        ArrayList<ShippersVO> errorList = new ArrayList<ShippersVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                ShippersVO VO = new ShippersVO();
                VO.setId(IdWorker.getId());
                VO.setName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setCategory(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? (String)data.get(1) : null);
                VO.setLegalPerson(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? (String)data.get(2) : null);
                VO.setBusinessLicense(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setAddress(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? (String)data.get(4) : null);
                VO.setRemark(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(5))) ? (String)data.get(5) : null);
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u8fd0\u8f93\u5546\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"name", data.get(0));
                query.eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId());
                ShippersEntity entity = (ShippersEntity)((Object)this.service.getOne((Wrapper)query));
                if (entity != null && (entity.getId() != null || entity.getId() != 0L)) {
                    VO.setErrorMsg("\u67e5\u91cd\u6821\u9a8c:'\u8fd0\u8f93\u5546\u540d\u79f0'\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u7c7b\u522b'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                if (!("\u9500\u552e".equals(data.get(1)) || "\u91c7\u8d2d".equals(data.get(1)) || "\u9500\u552e\u548c\u91c7\u8d2d".equals(data.get(1)))) {
                    VO.setErrorMsg("'\u7c7b\u522b'\u53ea\u80fd\u4e3a'\u9500\u552e'\u3001'\u91c7\u8d2d'\u6216\u8005'\u9500\u552e\u548c\u91c7\u8d2d'");
                    errorList.add(VO);
                    continue;
                }
                if ("\u9500\u552e".equals(data.get(1))) {
                    VO.setCategory("0");
                } else if ("\u91c7\u8d2d".equals(data.get(1))) {
                    VO.setCategory("1");
                } else {
                    VO.setCategory("2");
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List shippersEntities = BeanMapper.mapList(successList, ShippersEntity.class);
                for (ShippersEntity entity : shippersEntities) {
                    ShippersVO VO = (ShippersVO)((Object)BeanMapper.map((Object)((Object)entity), ShippersVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveBatch(shippersEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/downloadShippersFare"})
    @ResponseBody
    public void downloadShippersFare(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"shippersfare-import.xlsx", (String)"\u8fd0\u8f93\u5546\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportShippersFare"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportShippersFare(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ShippersfareVO> successList = new ArrayList<ShippersfareVO>();
        ArrayList<ShippersfareVO> errorList = new ArrayList<ShippersfareVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                ShippersfareVO VO = new ShippersfareVO();
                VO.setId(IdWorker.getId());
                VO.setShipperName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setStartDistance(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? new BigDecimal((String)data.get(1)) : null);
                VO.setEndDistance(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? new BigDecimal((String)data.get(2)) : null);
                VO.setDistance(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setTransportFare(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? new BigDecimal((String)data.get(4)) : null);
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u8fd0\u8f93\u5546\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"name", data.get(0));
                ShippersEntity entity = (ShippersEntity)((Object)this.service.getOne((Wrapper)query));
                if (entity == null || entity.getId() == null && entity.getId() == 0L) {
                    VO.setErrorMsg("\u8fd0\u8f93\u5546\u540d\u79f0\u5e93\u672a\u67e5\u627e\u5230\u8fd0\u8f93\u5546\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                    errorList.add(VO);
                    continue;
                }
                VO.setMid(entity.getId());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u5f00\u59cb\u8ddd\u79bb(\u516c\u91cc)'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                if (!StringUtils.isNumeric((CharSequence)((CharSequence)data.get(1)))) {
                    VO.setErrorMsg("'\u5f00\u59cb\u8ddd\u79bb(\u516c\u91cc)'\u53ea\u80fd\u4e3a\u6570\u5b57\u683c\u5f0f");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(2))) || data.get(2) == null) {
                    VO.setErrorMsg("'\u7ed3\u675f\u8ddd\u79bb(\u516c\u91cc)'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                if (!StringUtils.isNumeric((CharSequence)((CharSequence)data.get(1)))) {
                    VO.setErrorMsg("'\u7ed3\u675f\u8ddd\u79bb(\u516c\u91cc)'\u53ea\u80fd\u4e3a\u6570\u5b57\u683c\u5f0f");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(4))) || data.get(4) == null) {
                    VO.setErrorMsg("'\u8fd0\u8d39\u5355\u4ef7(\u5143/\u6bcf\u5428)'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(VO);
                    continue;
                }
                if (!StringUtils.isNumeric((CharSequence)((CharSequence)data.get(1)))) {
                    VO.setErrorMsg("'\u8fd0\u8d39\u5355\u4ef7(\u5143/\u6bcf\u5428)'\u53ea\u80fd\u4e3a\u6570\u5b57\u683c\u5f0f");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List shippersfareEntities = BeanMapper.mapList(successList, ShippersfareEntity.class);
                this.shippersfareService.saveBatch(shippersfareEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

