/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.SuppliercategoryEntity;
import com.ejianc.business.base.bean.SupplierinfoEntity;
import com.ejianc.business.base.service.ISuppliercategoryService;
import com.ejianc.business.base.service.ISupplierinfoService;
import com.ejianc.business.base.vo.SupplierinfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"supplyExcel"})
public class ExcelSupplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ISupplierinfoService service;
    @Autowired
    private ISuppliercategoryService categoryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "supply-info";

    @RequestMapping(value={"/downloadSupply"})
    @ResponseBody
    public void downloadSupply(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"supply-import.xlsx", (String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportSupply"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportSupply(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SupplierinfoVO> successList = new ArrayList<SupplierinfoVO>();
        ArrayList<SupplierinfoVO> errorList = new ArrayList<SupplierinfoVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                SupplierinfoVO VO = new SupplierinfoVO();
                VO.setId(IdWorker.getId());
                VO.setSupplyName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setCategoryName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? (String)data.get(1) : null);
                VO.setCreditLimit(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? new BigDecimal((String)data.get(2)) : null);
                VO.setCreditDate(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? new Integer((String)data.get(3)) : null);
                VO.setMinPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? new BigDecimal((String)data.get(4)) : null);
                VO.setCalculateMethod(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(5))) ? (String)data.get(5) : null);
                VO.setPayCondition(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(6))) ? (String)data.get(6) : null);
                VO.setLegalPerson(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(7))) ? (String)data.get(7) : null);
                VO.setBusinessLicense(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(8))) ? (String)data.get(8) : null);
                VO.setOrgCode(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(9))) ? (String)data.get(9) : null);
                VO.setAddress(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(10))) ? (String)data.get(10) : null);
                VO.setRemark(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(11))) ? (String)data.get(11) : null);
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(0))) || data.get(0) == null) {
                    VO.setErrorMsg("'\u4f9b\u5e94\u5546\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"supply_name", data.get(0));
                query.eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId());
                BaseEntity entity = (SupplierinfoEntity)((Object)this.service.getOne((Wrapper)query));
                if (entity != null && (entity.getId() != null || entity.getId() != 0L)) {
                    VO.setErrorMsg("\u67e5\u91cd\u6821\u9a8c:'\u4f9b\u5e94\u5546\u540d\u79f0'\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(1))) || data.get(1) == null) {
                    VO.setErrorMsg("'\u5206\u7c7b\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                query = new QueryWrapper();
                query.eq((Object)"name", data.get(1));
                entity = (SuppliercategoryEntity)((Object)this.categoryService.getOne((Wrapper)query));
                if (entity == null || entity.getId() == null && entity.getId() == 0L) {
                    VO.setErrorMsg("\u4f9b\u5e94\u5546\u5206\u7c7b\u540d\u79f0\u5e93\u672a\u67e5\u627e\u5230\u5206\u7c7b\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(VO);
                    continue;
                }
                VO.setCategoryId(entity.getId());
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)data.get(5))) && data.get(5) != null) {
                    if ("\u5165\u5e93\u5f00\u59cb\u7b97".equals(data.get(5))) {
                        VO.setCalculateMethod("1");
                    } else if ("\u9a8c\u6536\u5f00\u59cb\u7b97".equals(data.get(5))) {
                        VO.setCalculateMethod("2");
                    } else {
                        VO.setErrorMsg("\u8ba1\u7b97\u65b9\u5f0f\u53ea\u80fd\u4e3a'\u5165\u5e93\u5f00\u59cb\u7b97'\u6216\u8005'\u9a8c\u6536\u5f00\u59cb\u7b97'");
                        errorList.add(VO);
                        continue;
                    }
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List supplierinfoEntities = BeanMapper.mapList(successList, SupplierinfoEntity.class);
                for (SupplierinfoEntity entity : supplierinfoEntities) {
                    SupplierinfoVO VO = (SupplierinfoVO)((Object)BeanMapper.map((Object)((Object)entity), SupplierinfoVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setCode((String)billCode.getData());
                }
                this.service.saveBatch(supplierinfoEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

