package com.ejianc.business.base.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.base.bean.WaagdetailEntity;
/**
 * 磅房信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_base_waag")
public class WaagEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 磅房编码
    @TableField(value="name")
    private String name; // 磅房名称
    @TableField(value="address")
    private String address; // 磅房位置
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="waagdetailService",pidName = "mid")
    private List<WaagdetailEntity> waagdetailList = new ArrayList<>(); // 磅房信息子表
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<WaagdetailEntity> getWaagdetailList() {
        return waagdetailList;
    }

    public void setWaagdetailList(List<WaagdetailEntity> waagdetailList) {
        this.waagdetailList = waagdetailList;
    }
}
