package com.ejianc.business.base.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.base.bean.ShippersBankEntity;
import com.ejianc.business.base.bean.ShippersEntity;
import com.ejianc.business.base.bean.ShippersManageEntity;
import com.ejianc.business.base.service.IShippersService;
import com.ejianc.business.base.vo.CapacityVO;
import com.ejianc.business.base.vo.ShippersBankVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.base.bean.ShippersVehicleEntity;
import com.ejianc.business.base.service.IShippersVehicleService;
import com.ejianc.business.base.vo.ShippersVehicleVO;

/**
 * 运输车辆信息
 *
 * @author generator
 */
@Controller
@RequestMapping("shippersVehicle")
public class ShippersVehicleController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "shippers-vehicle";//此处需要根据实际修改

    @Autowired
    private IShippersVehicleService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShippersService shippersService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ShippersVehicleVO> saveOrUpdate(@RequestBody ShippersVehicleVO saveOrUpdateVO) {
        ShippersVehicleEntity entity = BeanMapper.map(saveOrUpdateVO, ShippersVehicleEntity.class);

        QueryWrapper query = new QueryWrapper();
        query.eq("plate_number", entity.getPlateNumber());
        query.eq("org_id", entity.getOrgId());
        if(entity.getId() != null)
            query.ne("id",entity.getId());
        int count = service.count(query);
        if (count > 0)
            throw new BusinessException("运输商车辆车牌号已存在，请修改运车辆车牌号后保存");

        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setStatus(1);
        }

        service.saveOrUpdate(entity, false);
        ShippersVehicleVO vo = BeanMapper.map(entity, ShippersVehicleVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ShippersVehicleVO> queryDetail(Long id) {
        ShippersVehicleEntity entity = service.selectById(id);
        ShippersVehicleVO vo = BeanMapper.map(entity, ShippersVehicleVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShippersVehicleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ShippersVehicleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /*CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ShippersVehicleVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ShippersVehicleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("plateNumber");
        fuzzyFields.add("defaultdriverName");
        fuzzyFields.add("motorcadeName");
        fuzzyFields.add("serviceCondition");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ShippersVehicleEntity> page = service.queryPage(param, false);
        IPage<ShippersVehicleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShippersVehicleVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ShippersVehicleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ShippersVehicle-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refShippersVehicleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ShippersVehicleVO>> refShippersVehicleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("plateNumber");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            String orgId = _con.getString("orgId");
            String shippersId = _con.getString("shippersId");
            String status = _con.getString("status");
            if (orgId != null) {
                param.getParams().put("org_id", new Parameter(QueryParam.EQ, orgId));
            }
            if (shippersId != null) {
                param.getParams().put("shipper_m_id", new Parameter(QueryParam.EQ, shippersId));
            }
            if (status != null) {
                param.getParams().put("status", new Parameter(QueryParam.EQ, status));
            }
        }

        IPage<ShippersVehicleEntity> page = service.queryPage(param, false);
        IPage<ShippersVehicleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShippersVehicleVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/queryVehicle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CapacityVO>> queryVehicle() {
        QueryWrapper query=new QueryWrapper();
////        LambdaQueryWrapper<ShippersVehicleEntity> lambdaQueryWrapper = Wrappers.<ShippersVehicleEntity>lambdaQuery();
        List<CapacityVO> list = new ArrayList<>();
        query.select("org_name,vehicle_type,count(vehicle_status='空闲' or null) as countsfree,count(*)-count(vehicle_status='空闲' or null) as countstask,count(*) as counts").groupBy("org_name","vehicle_type");
////        lambdaQueryWrapper.select(ShippersVehicleEntity.class,info->!info.getColumn().equals("counts"));
        List<ShippersVehicleEntity> vehicleList = service.list(query);
////        List<ShippersVehicleEntity> vehicleList = service.list(lambdaQueryWrapper);
        for (ShippersVehicleEntity shippersVehicleEntity : vehicleList) {
            CapacityVO capacityVO = new CapacityVO();
            capacityVO.setId(IdWorker.getId());
            capacityVO.setCompanyName(shippersVehicleEntity.getOrgName());
            capacityVO.setVehicleType(shippersVehicleEntity.getVehicleType());
            capacityVO.setVehicleFree(shippersVehicleEntity.getCountsfree());
            capacityVO.setVehicleTask(shippersVehicleEntity.getCountstask());
            capacityVO.setTotal(shippersVehicleEntity.getCount());
            list.add(capacityVO);
        }
//        List<CapacityVO> list = new ArrayList<>();

//        /**
//         * 中栋燃油
//         */
//        QueryWrapper query=new QueryWrapper();
//        query.eq("org_name","中栋");
//        query.eq("vehicle_type","燃油");
//        query.eq("vehicle_status","空闲");
//        List<ShippersVehicleEntity> vehicleList = service.list(query);
//        QueryWrapper query1=new QueryWrapper();
//        query1.eq("org_name","中栋");
//        query1.eq("vehicle_type","燃油");
//        query1.eq("vehicle_status","任务");
//        List<ShippersVehicleEntity> vehicleList1 = service.list(query1);
//        CapacityVO capacityVO = new CapacityVO();
//        capacityVO.setId(IdWorker.getId());
//        capacityVO.setCompanyName("中栋");
//        capacityVO.setVehicleType("燃油");
//        capacityVO.setVehicleFree(vehicleList.size());
//        capacityVO.setVehicleTask(vehicleList1.size());
//        capacityVO.setTotal(vehicleList.size()+vehicleList1.size());
//        list.add(capacityVO);
//
//        /**
//         * 中栋新能源
//         */
//        QueryWrapper query2=new QueryWrapper();
//        query2.eq("org_name","中栋");
//        query2.eq("vehicle_type","燃油");
//        query2.eq("vehicle_status","空闲");
//        List<ShippersVehicleEntity> vehicleList2 = service.list(query);
//        QueryWrapper query3=new QueryWrapper();
//        query3.eq("org_name","中栋");
//        query3.eq("vehicle_type","新能源");
//        query3.eq("vehicle_status","任务");
//        List<ShippersVehicleEntity> vehicleList3 = service.list(query1);
//        CapacityVO capacityVO1 = new CapacityVO();
//        capacityVO1.setId(IdWorker.getId());
//        capacityVO1.setCompanyName("中栋");
//        capacityVO1.setVehicleType("新能源");
//        capacityVO1.setVehicleFree(vehicleList2.size());
//        capacityVO1.setVehicleTask(vehicleList3.size());
//        capacityVO1.setTotal(vehicleList2.size()+vehicleList3.size());
//        list.add(capacityVO1);
        return CommonResponse.success("查询详情数据成功！", list);
    }

}
