package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.*;
import com.ejianc.business.base.service.*;

import com.ejianc.business.base.vo.ProductVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 产品导入
 */
@Controller
@RequestMapping("productExport")
public class ExcelProductController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProductService service;
    @Autowired
    private IProductCategoryService categoryService;
    @Autowired
    private IProductGradeService gradeService;
    @Autowired
    private IProductSpecService specService;
    @Autowired
    private IMaterialVarietiesService materialVarietiesService;

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "base-product";//此处需要根据实际修改
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadProduct")
    @ResponseBody
    public void downloadProduct(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "product-import.xlsx", "产品信息导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportProduct", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportProduct(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ProductVO> successList = new ArrayList<>();
        List<ProductVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    ProductVO VO = new ProductVO();
                    VO.setId(IdWorker.getId());
                    VO.setCategoryName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setSpecName(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setGradeName(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setAsphaltName(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
                    VO.setStoneName(StringUtils.isNotBlank(data.get(4)) ? data.get(4) : null);
                    VO.setName(StringUtils.isNotBlank(data.get(5)) ? data.get(5) : null);
                    VO.setAlias(StringUtils.isNotBlank(data.get(6)) ? data.get(6) : null);
                    VO.setComprehensiveUtilizationName(StringUtils.isNotBlank(data.get(7)) ? data.get(7) : null);
                    VO.setTaxRate(StringUtils.isNotBlank(data.get(8)) ? new BigDecimal(data.get(8)) : null);
                    VO.setSuggestedPrice(StringUtils.isNotBlank(data.get(9)) ? new BigDecimal(data.get(9)) : null);
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'产品类别'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(0));
                        ProductCategoryEntity entity = categoryService.getOne(query);
                        if (entity==null&&entity.getId()==null){
                            VO.setErrorMsg("产品分类库未查找到此分类名称，请检查");
                            errorList.add(VO);
                            continue;
                        }else {
                            VO.setCategoryId(entity.getId());
                        }
                    }

                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
                        VO.setErrorMsg("'产品规格'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(1));
                        ProductSpecEntity spec = specService.getOne(query);
                        if (spec!=null&&spec.getId()!=null){
                            VO.setSpecId(spec.getId());
                        }else{
                            VO.setErrorMsg("产品规格库未查找到此规格名称，请检查");
                            errorList.add(VO);
                            continue;
                        }

                    }
                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
                        VO.setErrorMsg("'产品级配'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(2));
                        ProductGradeEntity grade= gradeService.getOne(query);
                        if (grade!=null&&grade.getId()!=null){
                            VO.setGradeId(grade.getId());
                        }else{
                            VO.setErrorMsg("产品级配库未查找到此级配名称，请检查");
                            errorList.add(VO);
                            continue;
                        }

                    }
                    if (StringUtils.isEmpty(data.get(3)) || data.get(3) == null) {
                        VO.setErrorMsg("'沥青'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(3));
                        MaterialVarietiesEntity asphalt = materialVarietiesService.getOne(query);
                        if (asphalt!=null&&asphalt.getId()!=null){
                            VO.setAsphaltId(asphalt.getId());
                        }else{
                            VO.setErrorMsg("材料品种库未查找到此沥青名称，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(4)) || data.get(4) == null) {
                        VO.setErrorMsg("'石料'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(4));
                        MaterialVarietiesEntity stone = materialVarietiesService.getOne(query);
                        if (stone!=null&&stone.getId()!=null){
                            VO.setStoneId(stone.getId());
                        }else{
                            VO.setErrorMsg("材料品种库未查找到此石料名称，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(5)) || data.get(5) == null) {
                        VO.setErrorMsg("'产品名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(5));
                        query.eq("org_id",InvocationInfoProxy.getOrgId());
                        ProductEntity product = service.getOne(query);
                        if (product!=null&&product.getId()!=null){
                            VO.setErrorMsg("查重校验:'产品名称'已存在，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    successList.add(VO);
                }
                if (errorList.size()==0) {
                    List<ProductEntity> productEntities = BeanMapper.mapList(successList, ProductEntity.class);
                    for (ProductEntity entity : productEntities) {
                        ProductVO VO = BeanMapper.map(entity, ProductVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(productEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
