package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.*;
import com.ejianc.business.base.service.*;
import com.ejianc.business.base.vo.ShippersVO;
import com.ejianc.business.base.vo.ShippersfareVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;

import java.math.BigDecimal;
import java.util.*;

/**
 * 运输商导入
 */
@Controller
@RequestMapping("shippersExport")
public class ExcelShippersController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IShippersService service;
    @Autowired
    private IShippersfareService shippersfareService;

    @Autowired
    private IBillCodeApi billCodeApi;


    private static final String BILL_CODE = "base-shippers";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /********************限额设计指标分析清单表导入导出start**************/
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadShippers")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "shippers-import.xlsx", "运输商信息导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportShippers", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ShippersVO> successList = new ArrayList<>();
        List<ShippersVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    ShippersVO VO = new ShippersVO();
                    VO.setId(IdWorker.getId());
                    VO.setName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setCategory(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setLegalPerson(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setBusinessLicense(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
                    VO.setAddress(StringUtils.isNotBlank(data.get(4)) ? data.get(4) : null);
                    VO.setRemark(StringUtils.isNotBlank(data.get(5)) ? data.get(5) : null);

                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'运输商名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(0));
                        query.eq("org_id",InvocationInfoProxy.getOrgId());
                        ShippersEntity entity = service.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setErrorMsg("查重校验:'运输商名称'已存在，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
                        VO.setErrorMsg("'类别'不能为空");
                        errorList.add(VO);
                        continue;
                    }else if (!("销售".equals(data.get(1))||"采购".equals(data.get(1))||"销售和采购".equals(data.get(1)))){
                        VO.setErrorMsg("'类别'只能为'销售'、'采购'或者'销售和采购'");
                        errorList.add(VO);
                        continue;
                    }else {
                        if ("销售".equals(data.get(1))){
                            VO.setCategory("0");
                        }else if ("采购".equals(data.get(1))){
                            VO.setCategory("1");
                        }else {
                            VO.setCategory("2");
                        }
                    }

                    successList.add(VO);
                }
                if (errorList.size()==0) {
                    List<ShippersEntity> shippersEntities = BeanMapper.mapList(successList, ShippersEntity.class);
                    for (ShippersEntity entity : shippersEntities) {
                        ShippersVO VO = BeanMapper.map(entity, ShippersVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(shippersEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
    /**
     * 运输商子表导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadShippersFare")
    @ResponseBody
    public void downloadShippersFare(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "shippersfare-import.xlsx", "运输商信息导入模板");
    }
    /**
     * 运输商子表excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportShippersFare", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportShippersFare(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ShippersfareVO> successList = new ArrayList<>();
        List<ShippersfareVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    ShippersfareVO VO = new ShippersfareVO();
                    VO.setId(IdWorker.getId());
                    VO.setShipperName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setStartDistance(StringUtils.isNotBlank(data.get(1)) ? new BigDecimal(data.get(1)) : null);
                    VO.setEndDistance(StringUtils.isNotBlank(data.get(2)) ? new BigDecimal(data.get(2)) : null);
                    VO.setDistance(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
                    VO.setTransportFare(StringUtils.isNotBlank(data.get(4)) ? new BigDecimal(data.get(4)) : null);
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'运输商名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(0));
                        ShippersEntity entity = service.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setMid(entity.getId());
                        }else {
                            VO.setErrorMsg("运输商名称库未查找到运输商名称，请检查");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
                        VO.setErrorMsg("'开始距离(公里)'不能为空");
                        errorList.add(VO);
                        continue;
                    }else {
                        if (!StringUtils.isNumeric(data.get(1))){
                            VO.setErrorMsg("'开始距离(公里)'只能为数字格式");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
                        VO.setErrorMsg("'结束距离(公里)'不能为空");
                        errorList.add(VO);
                        continue;
                    }else {
                        if (!StringUtils.isNumeric(data.get(1))){
                            VO.setErrorMsg("'结束距离(公里)'只能为数字格式");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(4)) || data.get(4) == null) {
                        VO.setErrorMsg("'运费单价(元/每吨)'不能为空");
                        errorList.add(VO);
                        continue;
                    }else {
                        if (!StringUtils.isNumeric(data.get(1))){
                            VO.setErrorMsg("'运费单价(元/每吨)'只能为数字格式");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    successList.add(VO);
                }
                if (errorList.size()==0) {
                    List<ShippersfareEntity> shippersfareEntities = BeanMapper.mapList(successList, ShippersfareEntity.class);
                    shippersfareService.saveBatch(shippersfareEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
