package com.ejianc.business.base.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bean.SuppliercategoryEntity;
import com.ejianc.business.base.bean.SupplierinfoEntity;
import com.ejianc.business.base.service.ISuppliercategoryService;
import com.ejianc.business.base.service.ISupplierinfoService;
import com.ejianc.business.base.vo.SupplierinfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 供应商信息的导入导出
 */
@Controller
@RequestMapping("supplyExcel")
public class ExcelSupplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private ISupplierinfoService service;
    @Autowired
    private ISuppliercategoryService categoryService;

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "supply-info";//此处需要根据实际修改

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadSupply")
    @ResponseBody
    public void downloadSupply(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "supply-import.xlsx", "供应商信息导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSupply", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSupply(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SupplierinfoVO> successList = new ArrayList<>();
        List<SupplierinfoVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    SupplierinfoVO VO = new SupplierinfoVO();
                    VO.setId(IdWorker.getId());
                    VO.setSupplyName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setCategoryName(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setCreditLimit(StringUtils.isNotBlank(data.get(2)) ? new BigDecimal(data.get(2)) : null);
                    VO.setCreditDate(StringUtils.isNotBlank(data.get(3)) ? new Integer(data.get(3)) : null);
                    VO.setMinPrice(StringUtils.isNotBlank(data.get(4)) ? new BigDecimal(data.get(4)) : null);
                    VO.setCalculateMethod(StringUtils.isNotBlank(data.get(5)) ? data.get(5) : null);
                    VO.setPayCondition(StringUtils.isNotBlank(data.get(6)) ? data.get(6) : null);
                    VO.setLegalPerson(StringUtils.isNotBlank(data.get(7)) ? data.get(7) : null);
                    VO.setBusinessLicense(StringUtils.isNotBlank(data.get(8)) ? data.get(8) : null);
                    VO.setOrgCode(StringUtils.isNotBlank(data.get(9)) ? data.get(9) : null);
                    VO.setAddress(StringUtils.isNotBlank(data.get(10)) ? data.get(10) : null);
                    VO.setRemark(StringUtils.isNotBlank(data.get(11)) ? data.get(11) : null);
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    VO.setCreateTime(new Date());
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'供应商名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("supply_name",data.get(0));
                        query.eq("org_id",InvocationInfoProxy.getOrgId());
                        SupplierinfoEntity entity = service.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setErrorMsg("查重校验:'供应商名称'已存在，请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
                        VO.setErrorMsg("'分类名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else {
                        QueryWrapper query=new QueryWrapper();
                        query.eq("name",data.get(1));
                        SuppliercategoryEntity entity = categoryService.getOne(query);
                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
                            VO.setCategoryId(entity.getId());
                        }else {
                            VO.setErrorMsg("供应商分类名称库未查找到分类名称，请检查！");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    if (!(StringUtils.isEmpty(data.get(5)) || data.get(5) == null)) {
                        if ("入库开始算".equals(data.get(5))){
                            VO.setCalculateMethod("1");
                        }else if ("验收开始算".equals(data.get(5))){
                            VO.setCalculateMethod("2");
                        }else{
                            VO.setErrorMsg("计算方式只能为'入库开始算'或者'验收开始算'");
                            errorList.add(VO);
                            continue;
                        }
                    }
                    successList.add(VO);
                }
                if (errorList.size()==0){
                    List<SupplierinfoEntity> supplierinfoEntities = BeanMapper.mapList(successList, SupplierinfoEntity.class);
                    for (SupplierinfoEntity entity : supplierinfoEntities) {
                        SupplierinfoVO VO = BeanMapper.map(entity, SupplierinfoVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(supplierinfoEntities,successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
