package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 项目登记-外派人员
 * 
 * @author generator
 * 
 */
public class ProjectOuterPeopleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 项目主键
    private String employeeTypeOuter; // 人员类型
    private Long employeeIdOuter; // 人员ID
    private String employeeNameOuter; // 人员姓名
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDateOuter; // 到岗时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDateOuter; // 离岗时间
    private Integer sealFlag; // 是否带印章(0：否，1：是)
    private String memoOuter; // 备注
    

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getEmployeeTypeOuter() {
        return employeeTypeOuter;
    }

    public void setEmployeeTypeOuter(String employeeTypeOuter) {
        this.employeeTypeOuter = employeeTypeOuter;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeIdOuter() {
        return employeeIdOuter;
    }
    @ReferDeserialTransfer
    public void setEmployeeIdOuter(Long employeeIdOuter) {
        this.employeeIdOuter = employeeIdOuter;
    }
    public String getEmployeeNameOuter() {
        return employeeNameOuter;
    }

    public void setEmployeeNameOuter(String employeeNameOuter) {
        this.employeeNameOuter = employeeNameOuter;
    }
    public Date getBeginDateOuter() {
        return beginDateOuter;
    }

    public void setBeginDateOuter(Date beginDateOuter) {
        this.beginDateOuter = beginDateOuter;
    }
    public Date getChangeDateOuter() {
        return changeDateOuter;
    }

    public void setChangeDateOuter(Date changeDateOuter) {
        this.changeDateOuter = changeDateOuter;
    }
    public Integer getSealFlag() {
        return sealFlag;
    }

    public void setSealFlag(Integer sealFlag) {
        this.sealFlag = sealFlag;
    }
    public String getMemoOuter() {
        return memoOuter;
    }

    public void setMemoOuter(String memoOuter) {
        this.memoOuter = memoOuter;
    }
    
}
