/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.hystrix.ProjectHystrix;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.SupplierCooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="ejc-market-web", url="${common.env.feign-client-url}", path="ejc-market-web", fallback=ProjectHystrix.class)
public interface IProjectApi {
    @GetMapping(value={"/api/project/queryProjectBySourceId"})
    public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value="sourceId") String var1);

    @GetMapping(value={"/api/project/queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") String var1);

    @GetMapping(value={"/api/project/queryProjectByIds"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestParam(value="ids") List<Long> var1);

    @GetMapping(value={"/api/project/getProjectIdsByProperties"})
    public CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value="projectRange") int var1);

    @GetMapping(value={"/api/project/getProjectIdsByEngineeringType"})
    public CommonResponse<List<Long>> getProjectIdsByEngineeringType(@RequestParam(value="projectRange") int var1, @RequestParam(value="engineeringType", required=false) Long var2);

    @GetMapping(value={"/api/project/queryProjectByUserId"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/api/project/queryProjectList"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectList(@RequestParam(value="num", defaultValue="10") int var1);

    @PostMapping(value={"/api/project/queryProjectPage"})
    public CommonResponse<Page<ProjectRegisterVO>> queryProjectPage(@RequestBody QueryParam var1);

    @GetMapping(value={"/api/project/queryChildrenProjectByOrgId"})
    public CommonResponse<List<ProjectRegisterVO>> queryChildrenProjectByOrgId(@RequestParam(value="orgId") Long var1);

    @GetMapping(value={"/api/project/queryProjects"})
    public CommonResponse<List<Map>> queryProjects(@RequestParam(value="orgId") Long var1, @RequestParam(value="statusList", required=false) List<String> var2, @RequestParam(value="focusTypeList", required=false) List<String> var3, @RequestParam(value="engineeringTypeList", required=false) List<Long> var4, @RequestParam(value="searchText", required=false) String var5);

    @GetMapping(value={"/api/project/queryProjectDetail"})
    public CommonResponse<ProjectRegisterVO> queryProjectDetail(@RequestParam(value="projectId") Long var1);

    @PostMapping(value={"/api/project/queryProjectListByStatus"})
    public CommonResponse<List<Long>> queryProjectListByStatus(@RequestBody ProjectRegisterVO var1);

    @PostMapping(value={"/api/project/queryFilterProjects"})
    public CommonResponse<List<ProjectRegisterVO>> queryFilterProjects(@RequestBody FilterOrgIdVo var1);

    @PostMapping(value={"/api/project/queryFilterOrgIds"})
    public CommonResponse<List<Long>> queryFilterOrgIds(@RequestBody FilterOrgIdVo var1);

    @PostMapping(value={"/api/project/queryFilterOrgIdsBuStatus"})
    public CommonResponse<List<Long>> queryFilterOrgIdsBuStatus(@RequestParam(value="status") String var1);

    @PostMapping(value={"/api/project/querySupplierCooperate"})
    public CommonResponse<Map<Long, List<SupplierCooperateVO>>> querySupplierCooperate(@RequestBody List<Long> var1);

    @PostMapping(value={"/api/project/queryAllProj"})
    public CommonResponse<List<ProjectRegisterVO>> queryAllProj(@RequestBody QueryParam var1);

    @GetMapping(value={"/api/project/updateFinishSettleMny"})
    public CommonResponse<String> updateFinishSettleMny(@RequestParam(value="projectId") Long var1, @RequestParam(value="finishSettleMny") BigDecimal var2);
}

