package com.ejianc.business.market.hystrix;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.SupplierCooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 项目hystrix
 *
 * @author liyongjia
 *
 */
@Component
public class ProjectHystrix implements IProjectApi {


	@Override
	public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(String sourceId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * @param projectDepartmentId
	 * @Author mrsir_wxp
	 * @Date 2020/8/21 根据项目部id查询项目信息
	 * @Description queryProjectByProjectDepartmentId
	 * @Param [sourceId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.market.vo.ProjectRegisterVO>
	 */
	@Override
	public CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(String projectDepartmentId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(List<Long> ids) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<Long>> getProjectIdsByProperties(int projectRange) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<Long>> getProjectIdsByEngineeringType(int projectRange, Long engineeringType) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(Long userId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/***
	 * @Author mrsir_wxp
	 * @Date 2021/2/1 查询本下启用的项目，参数为需要查询的条数，默认十条
	 * @Description queryProjectList
	 * @Param [num]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryProjectList(int num) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * @param queryParam
	 * @Author mrsir_wxp
	 * @Date 2021/5/18
	 * @Description queryProjectPage
	 * @Param [queryParam]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@Override
	public CommonResponse<Page<ProjectRegisterVO>> queryProjectPage(QueryParam queryParam) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryChildrenProjectByOrgId(Long orgId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<Map>> queryProjects(Long orgId, List<String> statusList, List<String> focusTypeList,List<Long> engineeringTypeList,String searchText) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<ProjectRegisterVO> queryProjectDetail(Long projectId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<Long>> queryProjectListByStatus(@RequestBody ProjectRegisterVO vo) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryFilterProjects(FilterOrgIdVo filterOrgVo) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<Long>> queryFilterOrgIds(FilterOrgIdVo filterOrgVo) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<Long>> queryFilterOrgIdsBuStatus(String status) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<Map<Long, List<SupplierCooperateVO>>> querySupplierCooperate(List<Long> supplierIds) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryAllProj(QueryParam queryParam) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<Map<String, ProjectRegisterVO>> getProjectMapByCodes(List<String> codes) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * @description: 更新项目项目阶段
	 *
	 * @param projectId
	 * @param projectStage
	 * @return {@link CommonResponse< String>}
	 * @author songlx
	 * @date: 2024/7/11
	 */
	@Override
	public CommonResponse<String> changeProjectStage(Long projectId, String projectStage) {
		return CommonResponse.error("网络问题， 查询失败。");
	}
}
