package com.ejianc.business.market.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 中标结果主实体
 * 
 * @author generator
 * 
 */
public class ResultAnalysisVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 工程编码
    private Integer billState; // 单据状态（审批必须字段）
    private String billStateName;
    private Long orgId; // 所属组织
    private String orgName; // 所属组织名称
    private Long oppId; // 商机登记id
    private Long constructionUnit; // 建设单位
    private String constructionUnitName; // 建设单位名称
    private String followPerson; // 跟踪人
    private String followPersonName; // 跟踪人名称
    private String followPersonPhone; // 跟踪人电话
    private Long infoSource; // 信息来源
    private String infoSourceName; // 信息来源名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimatedBiddingDate; // 预计招标日期
    private BigDecimal biddingTaxMny; // 投标价格
    private Boolean isWinInfo; // 是否中标 1是0否
    private String isWinInfoName; // 是否中标 1是0否
    private BigDecimal biddingSubTaxMny; // 投标差价
    private BigDecimal biddingAvgTaxMny; // 投标均价
    private String engineeringName; // 工程名称
    private Long engineeringType;
    private String engineeringTypeName;
    private Long employeeId;
    private String employeeName;
    private String employeePhone;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date employeeDate; // 经办时间
    private BigDecimal actualTaxMny; // 中标价格

    List<ResultDetailVO> resultDetailList;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getIsWinInfoName() {
        return isWinInfoName;
    }

    public void setIsWinInfoName(String isWinInfoName) {
        this.isWinInfoName = isWinInfoName;
    }

    public BigDecimal getActualTaxMny() {
        return actualTaxMny;
    }

    public void setActualTaxMny(BigDecimal actualTaxMny) {
        this.actualTaxMny = actualTaxMny;
    }


    public Boolean getIsWinInfo() {
        return isWinInfo;
    }

    public void setIsWinInfo(Boolean winInfo) {
        isWinInfo = winInfo;
    }

    public List<ResultDetailVO> getResultDetailList() {
        return resultDetailList;
    }

    public void setResultDetailList(List<ResultDetailVO> resultDetailList) {
        this.resultDetailList = resultDetailList;
    }

    public Date getEmployeeDate() {
        return employeeDate;
    }

    public void setEmployeeDate(Date employeeDate) {
        this.employeeDate = employeeDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="business-opportunity-register")
    public Long getOppId() {
        return oppId;
    }

    @ReferDeserialTransfer
    public void setOppId(Long oppId) {
        this.oppId = oppId;
    }
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }
    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    public String getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(String followPerson) {
        this.followPerson = followPerson;
    }
    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }
    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }
    public Long getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }
    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }
    public Date getEstimatedBiddingDate() {
        return estimatedBiddingDate;
    }

    public void setEstimatedBiddingDate(Date estimatedBiddingDate) {
        this.estimatedBiddingDate = estimatedBiddingDate;
    }
    public BigDecimal getBiddingTaxMny() {
        return biddingTaxMny;
    }

    public void setBiddingTaxMny(BigDecimal biddingTaxMny) {
        this.biddingTaxMny = biddingTaxMny;
    }
    public BigDecimal getBiddingSubTaxMny() {
        return biddingSubTaxMny;
    }

    public void setBiddingSubTaxMny(BigDecimal biddingSubTaxMny) {
        this.biddingSubTaxMny = biddingSubTaxMny;
    }
    public BigDecimal getBiddingAvgTaxMny() {
        return biddingAvgTaxMny;
    }

    public void setBiddingAvgTaxMny(BigDecimal biddingAvgTaxMny) {
        this.biddingAvgTaxMny = biddingAvgTaxMny;
    }
    
}
