package com.ejianc.business.market.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @Author liyongjia
 * @Date 2020/5/11 商机登记
 * @Description BusinessOpportunityVO
 */

public class BusinessOpportunityVO  extends BaseVO {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 工程名称
     */
    private String engineeringName;

    /**
     * 所属组织
     */
    private Long orgId;

    /**
     * 工程编码
     */
    private String billCode;

    /**
     * 工程类型
     */
    private Long engineeringType;

    /**
     * 工程类型名称
     */
    private String engineeringTypeName;

    /**
     * 信息来源
     */
    private Long infoSource;

    /**
     * 信息来源名称
     */
    private String infoSourceName;

    /**
     * 跟踪人
     */
    private Long followPerson;

    /**
     * 跟踪人名称
     */
    private String followPersonName;

    /**
     * 跟踪人电话
     */
    private String followPersonPhone;

    /**
     * 项目阶段
     */
    private Long engineeringStage;

    /**
     * 项目阶段名称
     */
    private String engineeringStageName;

    /**
     * 地区
     */
    private String area;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 建设单位
     */
    private Long constructionUnit;

    /**
     * 建设单位名称
     */
    private String constructionUnitName;

    /**
     * 联系人
     */
    private String connectPerson;

    /**
     * 联系电话
     */
    private String connectPhone;

    /**
     * 投资主体
     */
    private Long investor;

    /**
     * 资金来源
     */
    private String fundsSource;

    /**
     * 总造价(万元)
     */
    private BigDecimal costTotal;

    /**
     * 招标形式
     */
    private Long biddingForm;

    /**
     * 招标形式名称
     */
    private String biddingFormName;

    /**
     * 预计招标日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimatedBiddingDate;

    /**
     * 计划开工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedCommencementDate;

    /**
     * 计划竣工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;

    /**
     * 工程概况
     */
    private String projectOverview;

    /**
     * 建筑面积(㎡)
     */
    private BigDecimal builtArea;

    /**
     * 结构类型
     */
    private Long structureType;

    /**
     * 工程用途
     */
    private Long engineeringPurpose;

    /**
     * 质量等级
     */
    private Long qualityLeave;

    /**
     * 是否立项
     */
    private Boolean projectIsSet;

    /**
     * 项目立项单据id
     */
    private Long projectSetId;

    /**
     * 中标状态 1是 0否
     */
    private Integer resultState;

    /**
     * 中标状态 1是 0否
     */
    private String resultStateStr;

    public String getResultStateStr() {
        return resultStateStr;
    }

    public void setResultStateStr(String resultStateStr) {
        this.resultStateStr = resultStateStr;
    }

    public Integer getResultState() {
        return resultState;
    }

    public void setResultState(Integer resultState) {
        this.resultState = resultState;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billType) {
        this.billState = billType;
    }

    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public Long getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getFollowPerson() {
        return followPerson;
    }

    @ReferDeserialTransfer
    public void setFollowPerson(Long followPerson) {
        this.followPerson = followPerson;
    }

    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }

    public Long getEngineeringStage() {
        return engineeringStage;
    }

    public void setEngineeringStage(Long engineeringStage) {
        this.engineeringStage = engineeringStage;
    }

    public String getEngineeringStageName() {
        return engineeringStageName;
    }

    public void setEngineeringStageName(String engineeringStageName) {
        this.engineeringStageName = engineeringStageName;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ReferSerialTransfer(referCode="support-customer")
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    @ReferDeserialTransfer
    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    public String getConnectPerson() {
        return connectPerson;
    }

    public void setConnectPerson(String connectPerson) {
        this.connectPerson = connectPerson;
    }

    public String getConnectPhone() {
        return connectPhone;
    }

    public void setConnectPhone(String connectPhone) {
        this.connectPhone = connectPhone;
    }

    public Long getInvestor() {
        return investor;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public Long getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getEstimatedBiddingDate() {
        return estimatedBiddingDate;
    }

    public void setEstimatedBiddingDate(Date estimatedBiddingDate) {
        this.estimatedBiddingDate = estimatedBiddingDate;
    }

    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }

    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }

    public Long getQualityLeave() {
        return qualityLeave;
    }

    public void setQualityLeave(Long qualityLeave) {
        this.qualityLeave = qualityLeave;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }

    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public Boolean getProjectIsSet() {
        return projectIsSet;
    }

    public void setProjectIsSet(Boolean projectIsSet) {
        this.projectIsSet = projectIsSet;
    }

    public Long getProjectSetId() {
        return projectSetId;
    }

    public void setProjectSetId(Long projectSetId) {
        this.projectSetId = projectSetId;
    }
}
