package com.ejianc.business.market.api;

import com.ejianc.business.market.hystrix.ProjectHystrix;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 项目rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-market-web", url="${common.env.feign-client-url}", path="ejc-market-web", fallback = ProjectHystrix.class)
public interface IProjectApi {

	/**
	 * 根据sourceId查询项目详情
	 *
	 * @param sourceId
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjectBySourceId")
	public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/8/21 根据项目部id查询项目信息
	 * @Description queryProjectByProjectDepartmentId
	 * @Param [sourceId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.market.vo.ProjectRegisterVO>
	 */
	@GetMapping(value = "/api/project/queryProjectByProjectDepartmentId")
	CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") String projectDepartmentId);

	/**
	 * 根据ids查询项目详情
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjectByIds")
	public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestParam(value = "ids") List<Long> ids);
	@GetMapping(value = "getDataByName")
	public CommonResponse<ProjectRegisterVO> getDataByName(@RequestParam("projectName") String projectName);
	/**
	 * 根据条件查询对应项目ID列表
	 *
	 * @param projectRange 1-全部项目，2-在建项目，3-完工项目，4-本年新签项目
	 * @return
	 */
	@GetMapping(value = "/api/project/getProjectIdsByProperties")
	CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value = "projectRange") int projectRange);


	@GetMapping(value = "/api/project/getProjectIdsByEngineeringType")
	CommonResponse<List<Long>> getProjectIdsByEngineeringType(@RequestParam(value = "projectRange") int projectRange,@RequestParam(value = "engineeringType",required = false) Long engineeringType) ;

	@GetMapping(value = "/api/project/saveContractMny")
	CommonResponse<ProjectRegisterVO> saveContractMny(@RequestParam("id") Long id,
															 @RequestParam("contractTaxMny") BigDecimal contractTaxMny, @RequestParam("contractMny") BigDecimal contractMny);
}
