package com.ejianc.business.market.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 工程登记
 */
public class ProjectRegisterVO extends BaseVO {
    private static final long serialVersionUID = 6397319563174429996L;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * 审批状态
     */
    private Integer billState;
    /**
     * 项目编号
     */
    private String code;

    /**
     * 项目名称
     */
    private String name;

    /**
     * 项目简称
     */
    private String shortName;//简称项目名称

    /**
     * 所属组织
     */
    private Long orgId;

    /**
     * 冗余所属组织名称
     */
    private String orgName;

    /**
     * 所属项目部Id
     */
    private Long projectDepartmentId;

    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    private String status;

    /**
     * 业务板块
     */
    private Long businessSector;

    /**
     * 业务板块名称
     */
    private String businessSectorName;

    /**
     * 项目类型：
     */
    private Long projectType;
    /**
     * 项目类型：
     */
    private String projectTypeName;

    /**
     * 签订日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 类型：1父项目，2执行项目
     */
    private String type;

    /**
     * 父项目id
     */
    private Long parentId;

    /**
     * 是否有子项目
     */
    private Boolean hasChild;

    /**
     * 项目经营合同
     */
    private Long contractId;

    /**
     * 发包单位
     */
    private Long pubUnit;

    /**
     * 冗余发包单位名称
     */
    private String pubUnitName;

    /**
     * 承包单位
     */
    private Long contractorUnit;

    /**
     * 冗余承包单位名称
     */
    private String contractorUnitName;

    /**
     * 项目地区
     */
    private String area;

    /**
     * 详细地址
     */
    private String address;
    /**
     * 纬度
     */
    private String lat;
    /**
     * 经度
     */
    private String lng;

    private String areaId; // 区域id
    private String areaCode; // 区域编码
    private String areaName; // 区域名称

    /**
     * 省份
     */
    private String province;

    /**
     * 市区
     */
    private String city;

    /**
     * 区县
     */
    private String region;

    /**
     * 信息来源
     */
    private Long infoSource;

    /**
     * 信息来源名称
     */
    private String infoSourceName;

    /**
     * 项目经理
     */
    private Long projectManager;

    /**
     * 项目经理名称
     */
    private String projectManagerName;

    /**
     * 投资主体
     */
    private Long investor;

    /**
     * 投资主体
     */
    private String investorName;

    /**
     * 总造价(万元)
     */
    private BigDecimal costTotal;

    /**
     * 合同开工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 合同完工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate;

    /**
     * 计划工期
     */
    private String planDuration;

    /**
     * 监理单位人员
     */
    private String supervisor;

    /**
     * 设计单位人员
     */
    private String designer;

    /**
     * 技术负责人
     */
    private Long technologyId;

    /**
     * 技术负责人
     */
    private String technologyName;

    /**
     * 安全员
     */
    private Long securityId;

    /**
     * 安全员
     */
    private String securityName;

    /**
     * 工程概况
     */
    private String projectOverview;
    private String projectScale; // 项目规模

    //数据同步字段
    /**
     * 数据在第三方系统中主键值
     */
    private String sourceId;
    private String sourceCode;
    /**
     * 数据来源系统Id
     */
    private String systemId;
    private BigDecimal contractTaxMny;//合同额
    private BigDecimal contractMny;//不含税合同额
    private String incomeArea;

    private String projectSource;//项目来源
    private String internalCooperationProject;//是否内部合作项目（是、否）
    private String firstBusiness;//一级业务
    private String secondBusiness;//二级业务
    private BigDecimal taxRate;//税率
    private String projectProperty;//项目属性1.执行项目2.子项目
    private Long bidCostId;//标前成本测算id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planStartDate; // 计划开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期

    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    @ReferSerialTransfer(referCode="zydx-preBidCostCalc")
    public Long getBidCostId() {
        return bidCostId;
    }
    @ReferDeserialTransfer
    public void setBidCostId(Long bidCostId) {
        this.bidCostId = bidCostId;
    }
    public String getProjectProperty() {
        return projectProperty;
    }

    public void setProjectProperty(String projectProperty) {
        this.projectProperty = projectProperty;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getIncomeArea() {
        return incomeArea;
    }

    public void setIncomeArea(String incomeArea) {
        this.incomeArea = incomeArea;
    }

    /**
     * 项目成员
     */
    private List<Map<String, Object>> membersList;

    private List<ProjectRegisterVO> children;

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getTechnologyId() {
        return technologyId;
    }
    @ReferDeserialTransfer
    public void setTechnologyId(Long technologyId) {
        this.technologyId = technologyId;
    }

    public String getTechnologyName() {
        return technologyName;
    }

    public void setTechnologyName(String technologyName) {
        this.technologyName = technologyName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSecurityId() {
        return securityId;
    }
    @ReferDeserialTransfer
    public void setSecurityId(Long securityId) {
        this.securityId = securityId;
    }

    public String getSecurityName() {
        return securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public String getShortName() {
        return shortName;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public String getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(String planDuration) {
        this.planDuration = planDuration;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInfoSource() {
        return infoSource;
    }

    @ReferDeserialTransfer
    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectManager() {
        return projectManager;
    }

    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ReferSerialTransfer(referCode="zydx-customer")
    public Long getPubUnit() {
        return pubUnit;
    }

    @ReferDeserialTransfer
    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getContractorUnit() {
        return contractorUnit;
    }

    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInvestor() {
        return investor;
    }

    @ReferDeserialTransfer
    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    @ReferDeserialTransfer
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getInvestorName() {
        return investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public String getCreateTimeStr() {
        return null != this.getCreateTime() ? sdf.format(this.getCreateTime()) : null;
    }

    public String getStatusName() {
        return StringUtils.isNotBlank(this.status) ? ("1".equals(this.status) ? "未开工" : "2".equals(this.status) ? "在建" : "完工") : null;
    }

    public String getTypeName() {
        return "1".equals(this.type) ? "自营" : "联营";
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBusinessSector() {
        return businessSector;
    }

    @ReferDeserialTransfer
    public void setBusinessSector(Long businessSector) {
        this.businessSector = businessSector;
    }

    public String getBusinessSectorName() {
        return businessSectorName;
    }

    public void setBusinessSectorName(String businessSectorName) {
        this.businessSectorName = businessSectorName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectType() {
        return projectType;
    }

    @ReferDeserialTransfer
    public void setProjectType(Long projectType) {
        this.projectType = projectType;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getParentId() {
        return parentId;
    }

    @ReferDeserialTransfer
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    @ReferSerialTransfer(referCode = "zy-income-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public List<Map<String, Object>> getMembersList() {
        return membersList;
    }

    public void setMembersList(List<Map<String, Object>> membersList) {
        this.membersList = membersList;
    }

    public Boolean getHasChild() {
        return hasChild;
    }

    public void setHasChild(Boolean hasChild) {
        this.hasChild = hasChild;
    }

    public List<ProjectRegisterVO> getChildren() {
        return children;
    }

    public void setChildren(List<ProjectRegisterVO> children) {
        this.children = children;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }

    public String getProjectSource() {
        return projectSource;
    }

    public void setProjectSource(String projectSource) {
        this.projectSource = projectSource;
    }

    public String getInternalCooperationProject() {
        return internalCooperationProject;
    }

    public void setInternalCooperationProject(String internalCooperationProject) {
        this.internalCooperationProject = internalCooperationProject;
    }

    public String getFirstBusiness() {
        return firstBusiness;
    }

    public void setFirstBusiness(String firstBusiness) {
        this.firstBusiness = firstBusiness;
    }

    public String getSecondBusiness() {
        return secondBusiness;
    }

    public void setSecondBusiness(String secondBusiness) {
        this.secondBusiness = secondBusiness;
    }
}
